package com.ruoyi.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.zjsgfa.domain.Tsyxclxx;
import com.ruoyi.project.zjsgfa.service.ITsyxclxxService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 特殊岩性常量信息Controller
 * 
 * @author ruoyi
 * @date 2025-07-08
 */
@RestController
@RequestMapping("/system/tsyxclxx")
public class TsyxclxxController extends BaseController
{
    @Autowired
    private ITsyxclxxService tsyxclxxService;

    /**
     * 查询特殊岩性常量信息列表
     */
    @PreAuthorize("@ss.hasPermi('system:tsyxclxx:list')")
    @GetMapping("/list")
    public TableDataInfo list(Tsyxclxx tsyxclxx)
    {
        startPage();
        List<Tsyxclxx> list = tsyxclxxService.selectTsyxclxxList(tsyxclxx);
        return getDataTable(list);
    }

    /**
     * 导出特殊岩性常量信息列表
     */
    @PreAuthorize("@ss.hasPermi('system:tsyxclxx:export')")
    @Log(title = "特殊岩性常量信息", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, Tsyxclxx tsyxclxx)
    {
        List<Tsyxclxx> list = tsyxclxxService.selectTsyxclxxList(tsyxclxx);
        ExcelUtil<Tsyxclxx> util = new ExcelUtil<Tsyxclxx>(Tsyxclxx.class);
        util.exportExcel(response, list, "特殊岩性常量信息数据");
    }

    /**
     * 获取特殊岩性常量信息详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:tsyxclxx:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(tsyxclxxService.selectTsyxclxxById(id));
    }

    /**
     * 新增特殊岩性常量信息
     */
    @PreAuthorize("@ss.hasPermi('system:tsyxclxx:add')")
    @Log(title = "特殊岩性常量信息", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody Tsyxclxx tsyxclxx)
    {
        return toAjax(tsyxclxxService.insertTsyxclxx(tsyxclxx));
    }

    /**
     * 修改特殊岩性常量信息
     */
    @PreAuthorize("@ss.hasPermi('system:tsyxclxx:edit')")
    @Log(title = "特殊岩性常量信息", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody Tsyxclxx tsyxclxx)
    {
        return toAjax(tsyxclxxService.updateTsyxclxx(tsyxclxx));
    }

    /**
     * 删除特殊岩性常量信息
     */
    @PreAuthorize("@ss.hasPermi('system:tsyxclxx:remove')")
    @Log(title = "特殊岩性常量信息", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(tsyxclxxService.deleteTsyxclxxByIds(ids));
    }
}
