package com.ruoyi.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.zjsgfa.domain.SjSggyGjsbxnyq;
import com.ruoyi.project.zjsgfa.service.ISjSggyGjsbxnyqService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 设计-施工概要-关键设备性能要求Controller
 * 
 * @author ruoyi
 * @date 2025-08-18
 */
@RestController
@RequestMapping("/system/sjSggyGjsbxnyq")
public class SjSggyGjsbxnyqController extends BaseController
{
    @Autowired
    private ISjSggyGjsbxnyqService sjSggyGjsbxnyqService;

    /**
     * 查询设计-施工概要-关键设备性能要求列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyGjsbxnyq:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjSggyGjsbxnyq sjSggyGjsbxnyq)
    {
        startPage();
        List<SjSggyGjsbxnyq> list = sjSggyGjsbxnyqService.selectSjSggyGjsbxnyqList(sjSggyGjsbxnyq);
        return getDataTable(list);
    }

    /**
     * 导出设计-施工概要-关键设备性能要求列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyGjsbxnyq:export')")
    @Log(title = "设计-施工概要-关键设备性能要求", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjSggyGjsbxnyq sjSggyGjsbxnyq)
    {
        List<SjSggyGjsbxnyq> list = sjSggyGjsbxnyqService.selectSjSggyGjsbxnyqList(sjSggyGjsbxnyq);
        ExcelUtil<SjSggyGjsbxnyq> util = new ExcelUtil<SjSggyGjsbxnyq>(SjSggyGjsbxnyq.class);
        util.exportExcel(response, list, "设计-施工概要-关键设备性能要求数据");
    }

    /**
     * 获取设计-施工概要-关键设备性能要求详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyGjsbxnyq:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjSggyGjsbxnyqService.selectSjSggyGjsbxnyqById(id));
    }

    /**
     * 新增设计-施工概要-关键设备性能要求
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyGjsbxnyq:add')")
    @Log(title = "设计-施工概要-关键设备性能要求", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjSggyGjsbxnyq sjSggyGjsbxnyq)
    {
        return toAjax(sjSggyGjsbxnyqService.insertSjSggyGjsbxnyq(sjSggyGjsbxnyq));
    }

    /**
     * 修改设计-施工概要-关键设备性能要求
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyGjsbxnyq:edit')")
    @Log(title = "设计-施工概要-关键设备性能要求", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjSggyGjsbxnyq sjSggyGjsbxnyq)
    {
        return toAjax(sjSggyGjsbxnyqService.updateSjSggyGjsbxnyq(sjSggyGjsbxnyq));
    }

    /**
     * 删除设计-施工概要-关键设备性能要求
     */
    //@PreAuthorize("@ss.hasPermi('system:sjSggyGjsbxnyq:remove')")
    @Log(title = "设计-施工概要-关键设备性能要求", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjSggyGjsbxnyqService.deleteSjSggyGjsbxnyqByIds(ids));
    }
}
