package com.zjsgfa.project.zjsgfa.service.impl;

import java.nio.charset.StandardCharsets;
import java.util.List;

import cn.hutool.core.codec.Base64;
import com.zjsgfa.common.utils.DateUtils;
import com.zjsgfa.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.crypto.codec.Utf8;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjZysxMapper;
import com.zjsgfa.project.zjsgfa.domain.SjZysx;
import com.zjsgfa.project.zjsgfa.service.ISjZysxService;

/**
 * 设计信息-注意事项Service业务层处理
 * 
 * @author
 * @date 2025-07-22
 */
@Service
public class SjZysxServiceImpl implements ISjZysxService 
{
    @Autowired
    private SjZysxMapper sjZysxMapper;

    /**
     * 查询设计信息-注意事项
     * 
     * @param id 设计信息-注意事项主键
     * @return 设计信息-注意事项
     */
    @Override
    public SjZysx selectSjZysxById(Long id)
    {
        return sjZysxMapper.selectSjZysxById(id);
    }

    /**
     * 查询设计信息-注意事项列表
     * 
     * @param sjZysx 设计信息-注意事项
     * @return 设计信息-注意事项
     */
    @Override
    public List<SjZysx> selectSjZysxList(SjZysx sjZysx)
    {
        return sjZysxMapper.selectSjZysxList(sjZysx);
    }

    /**
     * 新增设计信息-注意事项
     * 
     * @param sjZysx 设计信息-注意事项
     * @return 结果
     */
    @Override
    public int insertSjZysx(SjZysx sjZysx)
    {
        String lb = sjZysx.getLb();
        if("喷漏卡塌".equals(lb) || "特殊岩性风险".equals(lb)){
            if(StringUtils.isNotEmpty(sjZysx.getZysx())){
                sjZysx.setZysx(new String(Base64.decode(sjZysx.getZysx()), StandardCharsets.UTF_8));
            }
        }
        return sjZysxMapper.insertSjZysx(sjZysx);
    }

    /**
     * 修改设计信息-注意事项
     * 
     * @param sjZysx 设计信息-注意事项
     * @return 结果
     */
    @Override
    public int updateSjZysx(SjZysx sjZysx)
    {
        String lb = sjZysx.getLb();
        if("喷漏卡塌".equals(lb) || "特殊岩性风险".equals(lb)){
            if(StringUtils.isNotEmpty(sjZysx.getZysx())){
                sjZysx.setZysx(new String(Base64.decode(sjZysx.getZysx()), StandardCharsets.UTF_8));
            }
        }

        sjZysx.setUpdateTime(DateUtils.getNowDate());
        return sjZysxMapper.updateSjZysx(sjZysx);
    }

    /**
     * 批量删除设计信息-注意事项
     * 
     * @param ids 需要删除的设计信息-注意事项主键
     * @return 结果
     */
    @Override
    public int deleteSjZysxByIds(Long[] ids)
    {
        return sjZysxMapper.deleteSjZysxByIds(ids);
    }

    /**
     * 删除设计信息-注意事项信息
     * 
     * @param id 设计信息-注意事项主键
     * @return 结果
     */
    @Override
    public int deleteSjZysxById(Long id)
    {
        return sjZysxMapper.deleteSjZysxById(id);
    }
}
