package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.zjsgfa.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjFdfxMapper;
import com.zjsgfa.project.zjsgfa.domain.SjFdfx;
import com.zjsgfa.project.zjsgfa.service.ISjFdfxService;

/**
 * 设计-分段分析Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-09-11
 */
@Service
public class SjFdfxServiceImpl implements ISjFdfxService 
{
    @Autowired
    private SjFdfxMapper sjFdfxMapper;

    /**
     * 查询设计-分段分析
     * 
     * @param id 设计-分段分析主键
     * @return 设计-分段分析
     */
    @Override
    public SjFdfx selectSjFdfxById(Long id)
    {
        return sjFdfxMapper.selectSjFdfxById(id);
    }

    /**
     * 查询设计-分段分析列表
     * 
     * @param sjFdfx 设计-分段分析
     * @return 设计-分段分析
     */
    @Override
    public List<SjFdfx> selectSjFdfxList(SjFdfx sjFdfx)
    {
        return sjFdfxMapper.selectSjFdfxList(sjFdfx);
    }

    /**
     * 新增设计-分段分析
     * 
     * @param sjFdfx 设计-分段分析
     * @return 结果
     */
    @Override
    public int insertSjFdfx(SjFdfx sjFdfx)
    {
        return sjFdfxMapper.insertSjFdfx(sjFdfx);
    }

    /**
     * 修改设计-分段分析
     * 
     * @param sjFdfx 设计-分段分析
     * @return 结果
     */
    @Override
    public int updateSjFdfx(SjFdfx sjFdfx)
    {
        return sjFdfxMapper.updateSjFdfx(sjFdfx);
    }

    /**
     * 批量删除设计-分段分析
     * 
     * @param ids 需要删除的设计-分段分析主键
     * @return 结果
     */
    @Override
    public int deleteSjFdfxByIds(Long[] ids)
    {
        return sjFdfxMapper.deleteSjFdfxByIds(ids);
    }

    /**
     * 删除设计-分段分析信息
     * 
     * @param id 设计-分段分析主键
     * @return 结果
     */
    @Override
    public int deleteSjFdfxById(Long id)
    {
        return sjFdfxMapper.deleteSjFdfxById(id);
    }

    @Override
    public int pladd(SjFdfx sjFdfx) {
        List<SjFdfx> list = sjFdfx.getList();
        if(list.size()==0){
            return 0;
        }
//        List<SjFdfx> collect = list.stream().filter(it -> StringUtils.isEmpty(it.getGcdzfdid())).collect(Collectors.toList());
//        Map<String, List<SjFdfx>> groupedByList = list.stream().filter(it -> StringUtils.isNotEmpty(it.getGcdzfdid())).collect(Collectors.toList()).stream()
//                .collect(Collectors.groupingBy(SjFdfx::getGcdzfdid));
//        List<SjFdfx> addList =new ArrayList<>();
//        for (Map.Entry<String, List<SjFdfx>> entry : groupedByList.entrySet()) {
//            List<SjFdfx> sjFdfxList = entry.getValue();
//            SjFdfx sjFdfx1 = sjFdfxList.stream().filter(item -> StringUtils.isNotEmpty(item.getGcdzfd())).findFirst().orElse(null);
//            String gcdzfd="";
//            if(sjFdfx1!=null){
//                gcdzfd= sjFdfx1.getGcdzfd();
//            }
//
//            SjFdfx sjFdfx2 = sjFdfxList.stream().filter(item -> StringUtils.isNotEmpty(item.getHfyj())).findFirst().orElse(null);
//            String fdyj="";
//            if(sjFdfx2!=null){
//                fdyj= sjFdfx2.getHfyj();
//            }
//            for(SjFdfx item:sjFdfxList){
//                item.setGcdzfd(gcdzfd);
//                item.setHfyj(fdyj);
//                addList.add(item);
//            }
//        }
//        addList.addAll(collect);
        //删除数据
        sjFdfxMapper.deleteSjFdfxByZbid(list.get(0).getZbid());
        return sjFdfxMapper.insertSjFdfxBatch(list);
    }

    @Override
    public int importData(List<SjFdfx> sjFdfxList) {
        //删除数据
        sjFdfxMapper.deleteSjFdfxByZbid(sjFdfxList.get(0).getZbid());
        return sjFdfxMapper.insertSjFdfxBatch(sjFdfxList);
    }
}
