package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import com.zjsgfa.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import java.util.ArrayList;
import com.zjsgfa.common.utils.StringUtils;
import org.springframework.transaction.annotation.Transactional;
import com.zjsgfa.project.zjsgfa.domain.SgfambKcxx;
import com.zjsgfa.project.zjsgfa.mapper.SgfambMapper;
import com.zjsgfa.project.zjsgfa.domain.Sgfamb;
import com.zjsgfa.project.zjsgfa.service.ISgfambService;

/**
 * 施工方案模板管理Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-09-23
 */
@Service
public class SgfambServiceImpl implements ISgfambService 
{
    @Autowired
    private SgfambMapper sgfambMapper;

    /**
     * 查询施工方案模板管理
     * 
     * @param id 施工方案模板管理主键
     * @return 施工方案模板管理
     */
    @Override
    public Sgfamb selectSgfambById(Long id)
    {
        return sgfambMapper.selectSgfambById(id);
    }

    /**
     * 查询施工方案模板管理列表
     * 
     * @param sgfamb 施工方案模板管理
     * @return 施工方案模板管理
     */
    @Override
    public List<Sgfamb> selectSgfambList(Sgfamb sgfamb)
    {
        return sgfambMapper.selectSgfambList(sgfamb);
    }

    /**
     * 新增施工方案模板管理
     * 
     * @param sgfamb 施工方案模板管理
     * @return 结果
     */
    @Transactional
    @Override
    public int insertSgfamb(Sgfamb sgfamb)
    {
        sgfamb.setCreatedBy(SecurityUtils.getLoginUser().getUser().getNickName());
        int rows = sgfambMapper.insertSgfamb(sgfamb);
        return rows;
    }

    /**
     * 修改施工方案模板管理
     * 
     * @param sgfamb 施工方案模板管理
     * @return 结果
     */
    @Transactional
    @Override
    public int updateSgfamb(Sgfamb sgfamb)
    {
        sgfamb.setUpdateBy(SecurityUtils.getLoginUser().getUser().getNickName());
        sgfamb.setUpdateTime(DateUtils.getNowDate());
        return sgfambMapper.updateSgfamb(sgfamb);
    }

    /**
     * 批量删除施工方案模板管理
     * 
     * @param ids 需要删除的施工方案模板管理主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSgfambByIds(Long[] ids)
    {
        sgfambMapper.deleteSgfambKcxxByZbids(ids);
        return sgfambMapper.deleteSgfambByIds(ids);
    }

    /**
     * 删除施工方案模板管理信息
     * 
     * @param id 施工方案模板管理主键
     * @return 结果
     */
    @Transactional
    @Override
    public int deleteSgfambById(Long id)
    {
        sgfambMapper.deleteSgfambKcxxByZbid(id);
        return sgfambMapper.deleteSgfambById(id);
    }


}
