package com.zjsgfa.project.zjsgfa.mapper;

import java.util.List;
import com.zjsgfa.project.zjsgfa.domain.SjFdfx;

/**
 * 设计-分段分析Mapper接口
 * 
 * @author ruoyi
 * @date 2025-09-11
 */
public interface SjFdfxMapper 
{
    /**
     * 查询设计-分段分析
     * 
     * @param id 设计-分段分析主键
     * @return 设计-分段分析
     */
    public SjFdfx selectSjFdfxById(Long id);

    /**
     * 查询设计-分段分析列表
     * 
     * @param sjFdfx 设计-分段分析
     * @return 设计-分段分析集合
     */
    public List<SjFdfx> selectSjFdfxList(SjFdfx sjFdfx);

    /**
     * 新增设计-分段分析
     * 
     * @param sjFdfx 设计-分段分析
     * @return 结果
     */
    public int insertSjFdfx(SjFdfx sjFdfx);

    /**
     * 修改设计-分段分析
     * 
     * @param sjFdfx 设计-分段分析
     * @return 结果
     */
    public int updateSjFdfx(SjFdfx sjFdfx);

    /**
     * 删除设计-分段分析
     * 
     * @param id 设计-分段分析主键
     * @return 结果
     */
    public int deleteSjFdfxById(Long id);

    /**
     * 批量删除设计-分段分析
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteSjFdfxByIds(Long[] ids);

    int deleteSjFdfxByZbid(Long zbid);

    int insertSjFdfxBatch(List<SjFdfx> sjFdfxList);

}
