package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计信息-井眼轨迹_轨道分段参数对象 sj_jygj_gdfdcs
 * 
 * @author
 * @date 2025-06-26
 */
@Data
public class SjJygjGdfdcs extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 井深 */
    @Excel(name = "井深")
    private Double js;

    /** 井斜 */
    @Excel(name = "井斜")
    private Double jx;

    /** 方位 */
    @Excel(name = "方位")
    private Double fw;

    /** 垂深 */
    @Excel(name = "垂深")
    private Double cs;

    /** 水平位移 */
    @Excel(name = "水平位移")
    private Double spwy;

    /** 南北位移 */
    @Excel(name = "南北位移")
    private Double nbwy;

    /** 东西位移 */
    @Excel(name = "东西位移")
    private Double dxwy;

    /** 全角变化率 */
    @Excel(name = "全角变化率")
    private Double qjbhl;

    /** 工具面 */
    @Excel(name = "工具面")
    private Double gjm;

    /** 靶点 */
    @Excel(name = "靶点")
    private String bd;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

}
