package com.zjsgfa.project.zjsgfa.domain;

import java.math.BigDecimal;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;
import lombok.Data;

/**
 * 施工方案模板管理—开次信息对象 sgfamb_kcxx
 * 
 * @author ruoyi
 * @date 2025-09-23
 */
@Data
public class SgfambKcxx extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 主表id */
    @Excel(name = "主表id")
    private Long zbid;

    /** 开次 */
    @Excel(name = "开次")
    private String kc;

    /** 开始井深 */
    @Excel(name = "开始井深")
    private BigDecimal ksjs;

    /** 结束井深 */
    @Excel(name = "结束井深")
    private BigDecimal jsjs;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

}
