package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.JcxxJdxxMapper;
import com.zjsgfa.project.zjsgfa.domain.JcxxJdxx;
import com.zjsgfa.project.zjsgfa.service.IJcxxJdxxService;

/**
 * 基础信息-井队设置Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-11-28
 */
@Service
public class JcxxJdxxServiceImpl implements IJcxxJdxxService 
{
    @Autowired
    private JcxxJdxxMapper jcxxJdxxMapper;

    /**
     * 查询基础信息-井队设置
     * 
     * @param id 基础信息-井队设置主键
     * @return 基础信息-井队设置
     */
    @Override
    public JcxxJdxx selectJcxxJdxxById(Long id)
    {
        return jcxxJdxxMapper.selectJcxxJdxxById(id);
    }

    /**
     * 查询基础信息-井队设置列表
     * 
     * @param jcxxJdxx 基础信息-井队设置
     * @return 基础信息-井队设置
     */
    @Override
    public List<JcxxJdxx> selectJcxxJdxxList(JcxxJdxx jcxxJdxx)
    {
        return jcxxJdxxMapper.selectJcxxJdxxList(jcxxJdxx);
    }

    /**
     * 新增基础信息-井队设置
     * 
     * @param jcxxJdxx 基础信息-井队设置
     * @return 结果
     */
    @Override
    public int insertJcxxJdxx(JcxxJdxx jcxxJdxx)
    {
        return jcxxJdxxMapper.insertJcxxJdxx(jcxxJdxx);
    }

    /**
     * 修改基础信息-井队设置
     * 
     * @param jcxxJdxx 基础信息-井队设置
     * @return 结果
     */
    @Override
    public int updateJcxxJdxx(JcxxJdxx jcxxJdxx)
    {
        jcxxJdxx.setUpdateTime(DateUtils.getNowDate());
        return jcxxJdxxMapper.updateJcxxJdxx(jcxxJdxx);
    }

    /**
     * 批量删除基础信息-井队设置
     * 
     * @param ids 需要删除的基础信息-井队设置主键
     * @return 结果
     */
    @Override
    public int deleteJcxxJdxxByIds(Long[] ids)
    {
        return jcxxJdxxMapper.deleteJcxxJdxxByIds(ids);
    }

    /**
     * 删除基础信息-井队设置信息
     * 
     * @param id 基础信息-井队设置主键
     * @return 结果
     */
    @Override
    public int deleteJcxxJdxxById(Long id)
    {
        return jcxxJdxxMapper.deleteJcxxJdxxById(id);
    }
}
