package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计信息-井眼轨迹信息对象 sj_jygj_info
 * 
 * @author
 * @date 2025-06-26
 */
@Data
public class SjJygjInfo extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 轨道类型 */
    @Excel(name = "轨道类型")
    private String gdlx;

    /** 井口横坐标 */
    @Excel(name = "井口横坐标")
    private Double jkhzb;

    /** 井口纵坐标 */
    @Excel(name = "井口纵坐标")
    private Double jkzzb;

    /** 靶点横坐标 */
    @Excel(name = "靶点横坐标")
    private Double bdhzb;

    /** 靶点纵坐标 */
    @Excel(name = "靶点纵坐标")
    private Double bdzzb;

    /** 垂深 */
    @Excel(name = "垂深")
    private Double cs;

    /** 闭合距 */
    @Excel(name = "闭合距")
    private Double bhj;

    /** 闭合方向 */
    @Excel(name = "闭合方向")
    private Double bhfx;

    /** 靶半径 */
    @Excel(name = "靶半径")
    private Double bbj;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

}
