package com.zjsgfa.project.zjsgfa.domain;

import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计-分段施工措施-地层岩性对象 sj_fdsgcs_dcyx
 * 
 * @author
 * @date 2025-08-06
 */
@Data
public class SjFdsgcsDcyx extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 开次 */
    @Excel(name = "开次")
    private String kc;
    /** 地层名称 */
    @Excel(name = "地层名称")
    private String dcmc;

    /** 井段垂深 */
    @Excel(name = "井段垂深")
    private String jdcs;

    //井段斜深
    private String jdxs;

    /** 岩性 */
    @Excel(name = "岩性")
    private String yx;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    private Double kscs;
    private Double jscs;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setDcmc(String dcmc) 
    {
        this.dcmc = dcmc;
    }

    public String getDcmc() 
    {
        return dcmc;
    }

    public void setJdcs(String jdcs) 
    {
        this.jdcs = jdcs;
    }

    public String getJdcs() 
    {
        return jdcs;
    }

    public void setYx(String yx) 
    {
        this.yx = yx;
    }

    public String getYx() 
    {
        return yx;
    }

    public void setBz(String bz) 
    {
        this.bz = bz;
    }

    public String getBz() 
    {
        return bz;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("dcmc", getDcmc())
            .append("jdcs", getJdcs())
            .append("yx", getYx())
            .append("bz", getBz())
            .toString();
    }
}
