package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjLjjwMapper;
import com.zjsgfa.project.zjsgfa.domain.SjLjjw;
import com.zjsgfa.project.zjsgfa.service.ISjLjjwService;

/**
 * 设计-邻井井位Service业务层处理
 * 
 * @author
 * @date 2025-07-22
 */
@Service
public class SjLjjwServiceImpl implements ISjLjjwService 
{
    @Autowired
    private SjLjjwMapper sjLjjwMapper;

    /**
     * 查询设计-邻井井位
     * 
     * @param id 设计-邻井井位主键
     * @return 设计-邻井井位
     */
    @Override
    public SjLjjw selectSjLjjwById(Long id)
    {
        return sjLjjwMapper.selectSjLjjwById(id);
    }

    /**
     * 查询设计-邻井井位列表
     * 
     * @param sjLjjw 设计-邻井井位
     * @return 设计-邻井井位
     */
    @Override
    public List<SjLjjw> selectSjLjjwList(SjLjjw sjLjjw)
    {
        return sjLjjwMapper.selectSjLjjwList(sjLjjw);
    }

    /**
     * 新增设计-邻井井位
     * 
     * @param sjLjjw 设计-邻井井位
     * @return 结果
     */
    @Override
    public int insertSjLjjw(SjLjjw sjLjjw)
    {
        return sjLjjwMapper.insertSjLjjw(sjLjjw);
    }

    /**
     * 修改设计-邻井井位
     * 
     * @param sjLjjw 设计-邻井井位
     * @return 结果
     */
    @Override
    public int updateSjLjjw(SjLjjw sjLjjw)
    {
        return sjLjjwMapper.updateSjLjjw(sjLjjw);
    }

    /**
     * 批量删除设计-邻井井位
     * 
     * @param ids 需要删除的设计-邻井井位主键
     * @return 结果
     */
    @Override
    public int deleteSjLjjwByIds(Long[] ids)
    {
        return sjLjjwMapper.deleteSjLjjwByIds(ids);
    }

    /**
     * 删除设计-邻井井位信息
     * 
     * @param id 设计-邻井井位主键
     * @return 结果
     */
    @Override
    public int deleteSjLjjwById(Long id)
    {
        return sjLjjwMapper.deleteSjLjjwById(id);
    }

    @Override
    public int insertSjLjjwBatch(List<SjLjjw> list) {
        String jh = list.get(0).getJh();
        SjLjjw sjLjjw=new SjLjjw();
        sjLjjw.setJh(jh);
        sjLjjw.setLb1(list.get(0).getLb1());

        List<SjLjjw> sjLjjws = sjLjjwMapper.selectSjLjjwList(sjLjjw);

        Set<String> jhSet = sjLjjws.stream()
                .map(SjLjjw::getLjjh)
                .collect(Collectors.toSet());
        List<SjLjjw> difference = list.stream()
                .filter(item -> !jhSet.contains(item.getLjjh()))
                .collect(Collectors.toList());
        if(difference.size()>0){
            int i = sjLjjwMapper.insertSjLjjwBatch(difference);
            return i;
        }else {
            return 1;
        }

    }

    @Override
    public int deleteSjLjjwByJh(String jh) {
        return sjLjjwMapper.deleteSjLjjwByJh(jh);
    }
}
