package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjFdsgcsDcyxtMapper;
import com.zjsgfa.project.zjsgfa.domain.SjFdsgcsDcyxt;
import com.zjsgfa.project.zjsgfa.service.ISjFdsgcsDcyxtService;

/**
 * 地层压力图Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-12-09
 */
@Service
public class SjFdsgcsDcyxtServiceImpl implements ISjFdsgcsDcyxtService 
{
    @Autowired
    private SjFdsgcsDcyxtMapper sjFdsgcsDcyxtMapper;

    /**
     * 查询地层压力图
     * 
     * @param id 地层压力图主键
     * @return 地层压力图
     */
    @Override
    public SjFdsgcsDcyxt selectSjFdsgcsDcyxtById(Long id)
    {
        return sjFdsgcsDcyxtMapper.selectSjFdsgcsDcyxtById(id);
    }

    /**
     * 查询地层压力图列表
     * 
     * @param sjFdsgcsDcyxt 地层压力图
     * @return 地层压力图
     */
    @Override
    public List<SjFdsgcsDcyxt> selectSjFdsgcsDcyxtList(SjFdsgcsDcyxt sjFdsgcsDcyxt)
    {
        return sjFdsgcsDcyxtMapper.selectSjFdsgcsDcyxtList(sjFdsgcsDcyxt);
    }

    /**
     * 新增地层压力图
     * 
     * @param sjFdsgcsDcyxt 地层压力图
     * @return 结果
     */
    @Override
    public int insertSjFdsgcsDcyxt(SjFdsgcsDcyxt sjFdsgcsDcyxt)
    {
        sjFdsgcsDcyxtMapper.deleteSjFdsgcsDcyxtByZbid(sjFdsgcsDcyxt.getZbid());
        return sjFdsgcsDcyxtMapper.insertSjFdsgcsDcyxt(sjFdsgcsDcyxt);
    }

    /**
     * 修改地层压力图
     * 
     * @param sjFdsgcsDcyxt 地层压力图
     * @return 结果
     */
    @Override
    public int updateSjFdsgcsDcyxt(SjFdsgcsDcyxt sjFdsgcsDcyxt)
    {
        return sjFdsgcsDcyxtMapper.updateSjFdsgcsDcyxt(sjFdsgcsDcyxt);
    }

    /**
     * 批量删除地层压力图
     * 
     * @param ids 需要删除的地层压力图主键
     * @return 结果
     */
    @Override
    public int deleteSjFdsgcsDcyxtByIds(Long[] ids)
    {
        return sjFdsgcsDcyxtMapper.deleteSjFdsgcsDcyxtByIds(ids);
    }

    /**
     * 删除地层压力图信息
     * 
     * @param id 地层压力图主键
     * @return 结果
     */
    @Override
    public int deleteSjFdsgcsDcyxtById(Long id)
    {
        return sjFdsgcsDcyxtMapper.deleteSjFdsgcsDcyxtById(id);
    }
}
