package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.SjFdsgcsDcylZjymdtjbMapper;
import com.zjsgfa.project.zjsgfa.domain.SjFdsgcsDcylZjymdtjb;
import com.zjsgfa.project.zjsgfa.service.ISjFdsgcsDcylZjymdtjbService;

/**
 * 邻井钻井液密度统计Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-12-04
 */
@Service
public class SjFdsgcsDcylZjymdtjbServiceImpl implements ISjFdsgcsDcylZjymdtjbService 
{
    @Autowired
    private SjFdsgcsDcylZjymdtjbMapper sjFdsgcsDcylZjymdtjbMapper;

    /**
     * 查询邻井钻井液密度统计
     * 
     * @param id 邻井钻井液密度统计主键
     * @return 邻井钻井液密度统计
     */
    @Override
    public SjFdsgcsDcylZjymdtjb selectSjFdsgcsDcylZjymdtjbById(Long id)
    {
        return sjFdsgcsDcylZjymdtjbMapper.selectSjFdsgcsDcylZjymdtjbById(id);
    }

    /**
     * 查询邻井钻井液密度统计列表
     * 
     * @param sjFdsgcsDcylZjymdtjb 邻井钻井液密度统计
     * @return 邻井钻井液密度统计
     */
    @Override
    public List<SjFdsgcsDcylZjymdtjb> selectSjFdsgcsDcylZjymdtjbList(SjFdsgcsDcylZjymdtjb sjFdsgcsDcylZjymdtjb)
    {
        return sjFdsgcsDcylZjymdtjbMapper.selectSjFdsgcsDcylZjymdtjbList(sjFdsgcsDcylZjymdtjb);
    }

    /**
     * 新增邻井钻井液密度统计
     * 
     * @param sjFdsgcsDcylZjymdtjb 邻井钻井液密度统计
     * @return 结果
     */
    @Override
    public int insertSjFdsgcsDcylZjymdtjb(SjFdsgcsDcylZjymdtjb sjFdsgcsDcylZjymdtjb)
    {
        return sjFdsgcsDcylZjymdtjbMapper.insertSjFdsgcsDcylZjymdtjb(sjFdsgcsDcylZjymdtjb);
    }

    /**
     * 修改邻井钻井液密度统计
     * 
     * @param sjFdsgcsDcylZjymdtjb 邻井钻井液密度统计
     * @return 结果
     */
    @Override
    public int updateSjFdsgcsDcylZjymdtjb(SjFdsgcsDcylZjymdtjb sjFdsgcsDcylZjymdtjb)
    {
        sjFdsgcsDcylZjymdtjb.setUpdateTime(DateUtils.getNowDate());
        return sjFdsgcsDcylZjymdtjbMapper.updateSjFdsgcsDcylZjymdtjb(sjFdsgcsDcylZjymdtjb);
    }

    /**
     * 批量删除邻井钻井液密度统计
     * 
     * @param ids 需要删除的邻井钻井液密度统计主键
     * @return 结果
     */
    @Override
    public int deleteSjFdsgcsDcylZjymdtjbByIds(Long[] ids)
    {
        return sjFdsgcsDcylZjymdtjbMapper.deleteSjFdsgcsDcylZjymdtjbByIds(ids);
    }

    /**
     * 删除邻井钻井液密度统计信息
     * 
     * @param id 邻井钻井液密度统计主键
     * @return 结果
     */
    @Override
    public int deleteSjFdsgcsDcylZjymdtjbById(Long id)
    {
        return sjFdsgcsDcylZjymdtjbMapper.deleteSjFdsgcsDcylZjymdtjbById(id);
    }
}
