package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计信息-分段钻井液性能设计对象 sj_zjy_fdxnb
 * 
 * @author
 * @date 2025-07-17
 */
@Data
public class SjZjyFdxnb extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 井段 */
    @Excel(name = "井段")
    private String jd;

    /** 密度(g/cm3) */
    @Excel(name = "密度(g/cm3)")
    private String md;

    /** 马氏漏斗黏度(s) */
    @Excel(name = "马氏漏斗黏度(s)")
    private String msldnd;

    /** API 滤失量(ml) */
    @Excel(name = "API 滤失量(ml)")
    private String apilsl;

    /** API 泥饼(mm) */
    @Excel(name = "API 泥饼(mm)")
    private String apinb;

    /** 静切力(Pa) */
    @Excel(name = "静切力(Pa)")
    private String jql;

    /** pH值 */
    @Excel(name = "pH值")
    private String ph;

    /** 含砂量(％) */
    @Excel(name = "含砂量(％)")
    private String hsl;

    /** 总固含(％) */
    @Excel(name = "总固含(％)")
    private String zgh;

    /** 摩阻系数 */
    @Excel(name = "摩阻系数")
    private String mzxs;

    /** 动切力 */
    @Excel(name = "动切力")
    private String dql;

    /** 塑性黏度 */
    @Excel(name = "塑性黏度")
    private String sxnd;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    private Double firstNumber;

}
