package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计信息-套管柱强度校核对象 sj_tg_tgqdjh
 * 
 * @author
 * @date 2025-07-17
 */
@Data
public class SjTgTgqdjh extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 开次 */
    @Excel(name = "开次")
    private String kc;

    /** 井段 */
    @Excel(name = "井段")
    private String jd;

    /** 每米质量 */
    @Excel(name = "每米质量")
    private String mmzl;

    /** 段净重 */
    @Excel(name = "段净重")
    private String djz;

    /** 累计重 */
    @Excel(name = "累计重")
    private String ljz;

    /** 抗外挤最大载荷 */
    @Excel(name = "抗外挤最大载荷")
    private String zdzhkwj;

    /** 抗外挤安全系数 */
    @Excel(name = "抗外挤安全系数")
    private String aqxskwj;

    /** 抗内压最大载荷 */
    @Excel(name = "抗内压最大载荷")
    private String zdzhkny;

    /** 抗内压安全系数 */
    @Excel(name = "抗内压安全系数")
    private String aqxskny;

    /** 抗拉最大载荷 */
    @Excel(name = "抗拉最大载荷")
    private String zdzhkl;

    /** 抗拉安全系数 */
    @Excel(name = "抗拉安全系数")
    private String aqxskl;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

}
