package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;
import lombok.Data;

/**
 * 基础信息-井队设置对象 jcxx_jdxx
 * 
 * @author ruoyi
 * @date 2025-11-28
 */
@Data
public class JcxxJdxx extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 钻井公司 */
    @Excel(name = "钻井公司")
    private String zjgs;

    /** 井队 */
    @Excel(name = "井队")
    private String zjjd;

    /** 钻机型号 */
    @Excel(name = "钻机型号")
    private String zjxh;

    /** 网电电压 */
    @Excel(name = "网电电压")
    private String wddy;

    /** 电控稳定输出功率 */
    @Excel(name = "电控稳定输出功率")
    private String dkwdscgl;

    /** 整机能力-钻机类型 */
    @Excel(name = "整机能力-钻机类型")
    private String zjnlZjlx;

    /** 整机能力-最大承受拉力 */
    @Excel(name = "整机能力-最大承受拉力")
    private String zjnlZdcsll;

    /** 整机能力-最高承受泵压 */
    @Excel(name = "整机能力-最高承受泵压")
    private String zjnlZgcsby;

    /** 旋转系统-电动转盘最大扭矩 */
    @Excel(name = "旋转系统-电动转盘最大扭矩")
    private String xzxtDdzp;

    /** 旋转系统-顶驱最大扭矩 */
    @Excel(name = "旋转系统-顶驱最大扭矩")
    private String xzxtDq;

    /** 循环系统-1#泵类型 */
    @Excel(name = "循环系统-1#泵类型")
    private String xhxtB1lx;

    /** 循环系统-1#泵型号 */
    @Excel(name = "循环系统-1#泵型号")
    private String xhxtB1xh;

    /** 循环系统-1#泵最大功率 */
    @Excel(name = "循环系统-1#泵最大功率")
    private String xhxtB1zdgl;

    /** 循环系统-2#泵类型 */
    @Excel(name = "循环系统-2#泵类型")
    private String xhxtB2lx;

    /** 循环系统-2#泵型号 */
    @Excel(name = "循环系统-2#泵型号")
    private String xhxtB2xh;

    /** 循环系统-2#泵最大功率 */
    @Excel(name = "循环系统-2#泵最大功率")
    private String xhxtB2zdgl;

    /** 循环系统-3#泵类型 */
    @Excel(name = "循环系统-3#泵类型")
    private String xhxtB3lx;

    /** 循环系统-3#泵型号 */
    @Excel(name = "循环系统-3#泵型号")
    private String xhxtB3xh;

    /** 循环系统-3#泵最大功率 */
    @Excel(name = "循环系统-3#泵最大功率")
    private String xhxtB3zdgl;

    /** 固控设备-振动筛类型 */
    @Excel(name = "固控设备-振动筛类型")
    private String gksbZdslx;

    /** 固控设备-1#离心机类型 */
    @Excel(name = "固控设备-1#离心机类型")
    private String gksbLxj1lx;

    /** 固控设备-1#离心机主电机功率 */
    @Excel(name = "固控设备-1#离心机主电机功率")
    private String gksbLxj1zdjgl;

    /** 固控设备-2#离心机类型 */
    @Excel(name = "固控设备-2#离心机类型")
    private String gksbLxj2lx;

    /** 固控设备-2#离心机主电机功率 */
    @Excel(name = "固控设备-2#离心机主电机功率")
    private String gksbLxj2zdjgl;

    /** 固控设备-3#离心机类型 */
    @Excel(name = "固控设备-3#离心机类型")
    private String gksbLxj3lx;

    /** 固控设备-3#离心机主电机功率 */
    @Excel(name = "固控设备-3#离心机主电机功率")
    private String gksbLxj3zdjgl;

    /** 循环罐-数量 */
    @Excel(name = "循环罐-数量")
    private String xhgSl;

    /** 循环罐-总容量 */
    @Excel(name = "循环罐-总容量")
    private String xhgZrl;

    /** 储备罐-个量 */
    @Excel(name = "储备罐-个量")
    private String cbgSl;

    /** 储备罐-总容量 */
    @Excel(name = "储备罐-总容量")
    private String cbgZrl;

    /** 设备分析意见 */
    @Excel(name = "设备分析意见")
    private String sbfxyj;

    /** 应急联系方式 */
    @Excel(name = "应急联系方式")
    private String yjlxr;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    /** 喷漏卡塌的预防管控措施 */
    @Excel(name = "喷漏卡塌的预防管控措施")
    private String yfgkcs;

    /** 完井施工措施 */
    @Excel(name = "完井施工措施")
    private String wjsgcs;

    /** 特殊岩性的知识 */
    @Excel(name = "特殊岩性的知识")
    private String tsyxzs;

}
