package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjFdsgcsDcylZjymdtjb;
import com.zjsgfa.project.zjsgfa.service.ISjFdsgcsDcylZjymdtjbService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 邻井钻井液密度统计Controller
 * 
 * @author ruoyi
 * @date 2025-12-04
 */
@RestController
@RequestMapping("/system/sjFdsgcsDcylZjymdtjb")
public class SjFdsgcsDcylZjymdtjbController extends BaseController
{
    @Autowired
    private ISjFdsgcsDcylZjymdtjbService sjFdsgcsDcylZjymdtjbService;

    /**
     * 查询邻井钻井液密度统计列表
     */
    @PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcylZjymdtjb:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjFdsgcsDcylZjymdtjb sjFdsgcsDcylZjymdtjb)
    {
        startPage();
        List<SjFdsgcsDcylZjymdtjb> list = sjFdsgcsDcylZjymdtjbService.selectSjFdsgcsDcylZjymdtjbList(sjFdsgcsDcylZjymdtjb);
        return getDataTable(list);
    }

    /**
     * 导出邻井钻井液密度统计列表
     */
    @PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcylZjymdtjb:export')")
    @Log(title = "邻井钻井液密度统计", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjFdsgcsDcylZjymdtjb sjFdsgcsDcylZjymdtjb)
    {
        List<SjFdsgcsDcylZjymdtjb> list = sjFdsgcsDcylZjymdtjbService.selectSjFdsgcsDcylZjymdtjbList(sjFdsgcsDcylZjymdtjb);
        ExcelUtil<SjFdsgcsDcylZjymdtjb> util = new ExcelUtil<SjFdsgcsDcylZjymdtjb>(SjFdsgcsDcylZjymdtjb.class);
        util.exportExcel(response, list, "邻井钻井液密度统计数据");
    }

    /**
     * 获取邻井钻井液密度统计详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcylZjymdtjb:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjFdsgcsDcylZjymdtjbService.selectSjFdsgcsDcylZjymdtjbById(id));
    }

    /**
     * 新增邻井钻井液密度统计
     */
    @PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcylZjymdtjb:add')")
    @Log(title = "邻井钻井液密度统计", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjFdsgcsDcylZjymdtjb sjFdsgcsDcylZjymdtjb)
    {
        return toAjax(sjFdsgcsDcylZjymdtjbService.insertSjFdsgcsDcylZjymdtjb(sjFdsgcsDcylZjymdtjb));
    }

    /**
     * 修改邻井钻井液密度统计
     */
    @PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcylZjymdtjb:edit')")
    @Log(title = "邻井钻井液密度统计", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjFdsgcsDcylZjymdtjb sjFdsgcsDcylZjymdtjb)
    {
        return toAjax(sjFdsgcsDcylZjymdtjbService.updateSjFdsgcsDcylZjymdtjb(sjFdsgcsDcylZjymdtjb));
    }

    /**
     * 删除邻井钻井液密度统计
     */
    @PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcylZjymdtjb:remove')")
    @Log(title = "邻井钻井液密度统计", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjFdsgcsDcylZjymdtjbService.deleteSjFdsgcsDcylZjymdtjbByIds(ids));
    }
}
