package com.zjsgfa.project.zjsgfa.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;

import com.zjsgfa.common.utils.StringUtils;
import com.zjsgfa.project.zt.domain.DjZqsjfx;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjFdsgcsDcylZjymdsjb;
import com.zjsgfa.project.zjsgfa.service.ISjFdsgcsDcylZjymdsjbService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 邻井钻井液密度数据Controller
 * 
 * @author ruoyi
 * @date 2025-12-04
 */
@RestController
@RequestMapping("/system/sjFdsgcsDcylZjymdsjb")
public class SjFdsgcsDcylZjymdsjbController extends BaseController
{
    @Autowired
    private ISjFdsgcsDcylZjymdsjbService sjFdsgcsDcylZjymdsjbService;

    /**
     * 查询邻井钻井液密度数据列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcylZjymdsjb:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjFdsgcsDcylZjymdsjb sjFdsgcsDcylZjymdsjb)
    {
        startPage();
        List<SjFdsgcsDcylZjymdsjb> list = sjFdsgcsDcylZjymdsjbService.selectSjFdsgcsDcylZjymdsjbList(sjFdsgcsDcylZjymdsjb);
        return getDataTable(list);
    }

    /**
     * 导出邻井钻井液密度数据列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcylZjymdsjb:export')")
    @Log(title = "邻井钻井液密度数据", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjFdsgcsDcylZjymdsjb sjFdsgcsDcylZjymdsjb)
    {
        List<SjFdsgcsDcylZjymdsjb> list = sjFdsgcsDcylZjymdsjbService.selectSjFdsgcsDcylZjymdsjbList(sjFdsgcsDcylZjymdsjb);
        ExcelUtil<SjFdsgcsDcylZjymdsjb> util = new ExcelUtil<SjFdsgcsDcylZjymdsjb>(SjFdsgcsDcylZjymdsjb.class);
        util.exportExcel(response, list, "邻井钻井液密度数据数据");
    }

    /**
     * 获取邻井钻井液密度数据详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcylZjymdsjb:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjFdsgcsDcylZjymdsjbService.selectSjFdsgcsDcylZjymdsjbById(id));
    }

    /**
     * 新增邻井钻井液密度数据
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcylZjymdsjb:add')")
    @Log(title = "邻井钻井液密度数据", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjFdsgcsDcylZjymdsjb sjFdsgcsDcylZjymdsjb)
    {
        return toAjax(sjFdsgcsDcylZjymdsjbService.insertSjFdsgcsDcylZjymdsjb(sjFdsgcsDcylZjymdsjb));
    }

    /**
     * 修改邻井钻井液密度数据
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcylZjymdsjb:edit')")
    @Log(title = "邻井钻井液密度数据", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjFdsgcsDcylZjymdsjb sjFdsgcsDcylZjymdsjb)
    {
        return toAjax(sjFdsgcsDcylZjymdsjbService.updateSjFdsgcsDcylZjymdsjb(sjFdsgcsDcylZjymdsjb));
    }

    /**
     * 删除邻井钻井液密度数据
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcylZjymdsjb:remove')")
    @Log(title = "邻井钻井液密度数据", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjFdsgcsDcylZjymdsjbService.deleteSjFdsgcsDcylZjymdsjbByIds(ids));
    }



    @GetMapping("/getDataList")
    public AjaxResult getDataList(SjFdsgcsDcylZjymdsjb sjFdsgcsDcylZjymdsjb)
    {
        List<SjFdsgcsDcylZjymdsjb> list = sjFdsgcsDcylZjymdsjbService.selectSjFdsgcsDcylZjymdsjbList(sjFdsgcsDcylZjymdsjb);

        List<Map> mapList=new ArrayList<>();

        Map<String, List<SjFdsgcsDcylZjymdsjb>> collect = list.stream()
                .collect(Collectors.groupingBy(SjFdsgcsDcylZjymdsjb::getLjjh));
        for(String key :collect.keySet()){
            Map<String, Object> map = new HashMap<>();
            map.put("name", key);
            List<Map> mapList2=new ArrayList<>();
            for(SjFdsgcsDcylZjymdsjb item:collect.get(key)){
                Map<String, Object> map2 = new HashMap<>();
                map2.put("depth", item.getQyjs());
                map2.put("density", item.getMd());
                mapList2.add(map2);
            }
            map.put("data", mapList2);
            mapList.add( map);
        }
        return AjaxResult.success(mapList);
    }
}
