package com.ruoyi.project.zt.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.zt.mapper.LjSzfxjgMapper;
import com.ruoyi.project.zt.domain.LjSzfxjg;
import com.ruoyi.project.zt.service.ILjSzfxjgService;

/**
 * 邻井-实钻分析结果Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-06-29
 */
@Service
public class LjSzfxjgServiceImpl implements ILjSzfxjgService 
{
    @Autowired
    private LjSzfxjgMapper ljSzfxjgMapper;

    /**
     * 查询邻井-实钻分析结果
     * 
     * @param id 邻井-实钻分析结果主键
     * @return 邻井-实钻分析结果
     */
    @Override
    public LjSzfxjg selectLjSzfxjgById(Long id)
    {
        return ljSzfxjgMapper.selectLjSzfxjgById(id);
    }

    /**
     * 查询邻井-实钻分析结果列表
     * 
     * @param ljSzfxjg 邻井-实钻分析结果
     * @return 邻井-实钻分析结果
     */
    @Override
    public List<LjSzfxjg> selectLjSzfxjgList(LjSzfxjg ljSzfxjg)
    {
        return ljSzfxjgMapper.selectLjSzfxjgList(ljSzfxjg);
    }

    /**
     * 新增邻井-实钻分析结果
     * 
     * @param ljSzfxjg 邻井-实钻分析结果
     * @return 结果
     */
    @Override
    public int insertLjSzfxjg(LjSzfxjg ljSzfxjg)
    {
        return ljSzfxjgMapper.insertLjSzfxjg(ljSzfxjg);
    }

    /**
     * 修改邻井-实钻分析结果
     * 
     * @param ljSzfxjg 邻井-实钻分析结果
     * @return 结果
     */
    @Override
    public int updateLjSzfxjg(LjSzfxjg ljSzfxjg)
    {
        ljSzfxjg.setUpdateTime(DateUtils.getNowDate());
        return ljSzfxjgMapper.updateLjSzfxjg(ljSzfxjg);
    }

    /**
     * 批量删除邻井-实钻分析结果
     * 
     * @param ids 需要删除的邻井-实钻分析结果主键
     * @return 结果
     */
    @Override
    public int deleteLjSzfxjgByIds(Long[] ids)
    {
        return ljSzfxjgMapper.deleteLjSzfxjgByIds(ids);
    }

    /**
     * 删除邻井-实钻分析结果信息
     * 
     * @param id 邻井-实钻分析结果主键
     * @return 结果
     */
    @Override
    public int deleteLjSzfxjgById(Long id)
    {
        return ljSzfxjgMapper.deleteLjSzfxjgById(id);
    }
}
