package com.ruoyi.project.zt.controller;

import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.framework.web.page.TableDataInfo;
import com.ruoyi.project.zt.domain.Jsaa;
import com.ruoyi.project.zt.domain.Jsba;
import com.ruoyi.project.zt.service.IJsbaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 地质简介基本数据Controller
 * 
 * @author ruoyi
 * @date 2025-07-10
 */
@RestController
@RequestMapping("/system/jsba")
public class JsbaController extends BaseController
{
    @Autowired
    private IJsbaService jsbaService;

    /**
     * 查询地质简介基本数据列表
     */
    @PreAuthorize("@ss.hasPermi('system:jsba:list')")
    @GetMapping("/list")
    public TableDataInfo list(Jsba jsba)
    {
        startPage();
        List<Jsba> list = jsbaService.selectJsbaList(jsba);
        return getDataTable(list);
    }

    @GetMapping("/selectJhs")
    public TableDataInfo selectJhs(Jsba jsba)
    {
//        startPage();
        List<Jsba> list = jsbaService.selectJsbaList(jsba);
        List<Jsba> jsbaList = list.stream()
                .map(user -> new Jsba(user.getJh(), user.getJkhzb(),user.getJkzzb(),user.getJdhzb(),user.getJdzzb()))
                .collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());

        return getDataTable(jsbaList);
    }

    //查询井型
    @GetMapping("/selectJxs")
    public AjaxResult selectJxs(Jsba jsba)
    {

        List<Jsba> list = jsbaService.selectJsbaList(jsba);
        List<String> collect = list.stream().map(Jsba::getJx).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
        return AjaxResult.success(collect);
    }

    //查询井型
    @GetMapping("/selectJbs")
    public AjaxResult selectJbs(Jsba jsba)
    {
        List<Jsba> list = jsbaService.selectJsbaList(jsba);
        List<String> collect = list.stream().map(Jsba::getJb).collect(Collectors.toList()).stream().distinct().collect(Collectors.toList());
        return AjaxResult.success(collect);
    }

    /**
     * 导出地质简介基本数据列表
     */
    @PreAuthorize("@ss.hasPermi('system:jsba:export')")
    @Log(title = "地质简介基本数据", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, Jsba jsba)
    {
        List<Jsba> list = jsbaService.selectJsbaList(jsba);
        ExcelUtil<Jsba> util = new ExcelUtil<Jsba>(Jsba.class);
        util.exportExcel(response, list, "地质简介基本数据数据");
    }

    /**
     * 获取地质简介基本数据详细信息
     */
    @PreAuthorize("@ss.hasPermi('system:jsba:query')")
    @GetMapping(value = "/{jh}")
    public AjaxResult getInfo(@PathVariable("jh") String jh)
    {
        return success(jsbaService.selectJsbaByJh(jh));
    }

    /**
     * 新增地质简介基本数据
     */
    @PreAuthorize("@ss.hasPermi('system:jsba:add')")
    @Log(title = "地质简介基本数据", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody Jsba jsba)
    {
        return toAjax(jsbaService.insertJsba(jsba));
    }

    /**
     * 修改地质简介基本数据
     */
    @PreAuthorize("@ss.hasPermi('system:jsba:edit')")
    @Log(title = "地质简介基本数据", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody Jsba jsba)
    {
        return toAjax(jsbaService.updateJsba(jsba));
    }

    /**
     * 删除地质简介基本数据
     */
    @PreAuthorize("@ss.hasPermi('system:jsba:remove')")
    @Log(title = "地质简介基本数据", businessType = BusinessType.DELETE)
	@DeleteMapping("/{jhs}")
    public AjaxResult remove(@PathVariable String[] jhs)
    {
        return toAjax(jsbaService.deleteJsbaByJhs(jhs));
    }
}
