package com.ruoyi.project.zjsgfa.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.zjsgfa.mapper.SjTgTgzMapper;
import com.ruoyi.project.zjsgfa.domain.SjTgTgz;
import com.ruoyi.project.zjsgfa.service.ISjTgTgzService;

/**
 * 设计信息-套管柱数据Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-07-17
 */
@Service
public class SjTgTgzServiceImpl implements ISjTgTgzService 
{
    @Autowired
    private SjTgTgzMapper sjTgTgzMapper;

    /**
     * 查询设计信息-套管柱数据
     * 
     * @param id 设计信息-套管柱数据主键
     * @return 设计信息-套管柱数据
     */
    @Override
    public SjTgTgz selectSjTgTgzById(Long id)
    {
        return sjTgTgzMapper.selectSjTgTgzById(id);
    }

    /**
     * 查询设计信息-套管柱数据列表
     * 
     * @param sjTgTgz 设计信息-套管柱数据
     * @return 设计信息-套管柱数据
     */
    @Override
    public List<SjTgTgz> selectSjTgTgzList(SjTgTgz sjTgTgz)
    {
        return sjTgTgzMapper.selectSjTgTgzList(sjTgTgz);
    }

    /**
     * 新增设计信息-套管柱数据
     * 
     * @param sjTgTgz 设计信息-套管柱数据
     * @return 结果
     */
    @Override
    public int insertSjTgTgz(SjTgTgz sjTgTgz)
    {
        return sjTgTgzMapper.insertSjTgTgz(sjTgTgz);
    }

    /**
     * 修改设计信息-套管柱数据
     * 
     * @param sjTgTgz 设计信息-套管柱数据
     * @return 结果
     */
    @Override
    public int updateSjTgTgz(SjTgTgz sjTgTgz)
    {
        sjTgTgz.setUpdateTime(DateUtils.getNowDate());
        return sjTgTgzMapper.updateSjTgTgz(sjTgTgz);
    }

    /**
     * 批量删除设计信息-套管柱数据
     * 
     * @param ids 需要删除的设计信息-套管柱数据主键
     * @return 结果
     */
    @Override
    public int deleteSjTgTgzByIds(Long[] ids)
    {
        return sjTgTgzMapper.deleteSjTgTgzByIds(ids);
    }

    /**
     * 删除设计信息-套管柱数据信息
     * 
     * @param id 设计信息-套管柱数据主键
     * @return 结果
     */
    @Override
    public int deleteSjTgTgzById(Long id)
    {
        return sjTgTgzMapper.deleteSjTgTgzById(id);
    }
}
