package com.ruoyi.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.zjsgfa.domain.SjZqfx;
import com.ruoyi.project.zjsgfa.service.ISjZqfxService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 设计-周期分析Controller
 * 
 * @author ruoyi
 * @date 2025-07-22
 */
@RestController
@RequestMapping("/system/sjZqfx")
public class SjZqfxController extends BaseController
{
    @Autowired
    private ISjZqfxService sjZqfxService;

    /**
     * 查询设计-周期分析列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZqfx:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjZqfx sjZqfx)
    {
//        startPage();
        List<SjZqfx> list = sjZqfxService.selectSjZqfxList(sjZqfx);
        return getDataTable(list);
    }

    /**
     * 导出设计-周期分析列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZqfx:export')")
    @Log(title = "设计-周期分析", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjZqfx sjZqfx)
    {
        List<SjZqfx> list = sjZqfxService.selectSjZqfxList(sjZqfx);
        ExcelUtil<SjZqfx> util = new ExcelUtil<SjZqfx>(SjZqfx.class);
        util.exportExcel(response, list, "设计-周期分析数据");
    }

    /**
     * 获取设计-周期分析详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZqfx:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjZqfxService.selectSjZqfxById(id));
    }

    /**
     * 新增设计-周期分析
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZqfx:add')")
    @Log(title = "设计-周期分析", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjZqfx sjZqfx)
    {
        return toAjax(sjZqfxService.insertSjZqfx(sjZqfx));
    }

    /**
     * 修改设计-周期分析
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZqfx:edit')")
    @Log(title = "设计-周期分析", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjZqfx sjZqfx)
    {
        return toAjax(sjZqfxService.updateSjZqfx(sjZqfx));
    }

    /**
     * 删除设计-周期分析
     */
    //@PreAuthorize("@ss.hasPermi('system:sjZqfx:remove')")
    @Log(title = "设计-周期分析", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjZqfxService.deleteSjZqfxByIds(ids));
    }
}
