package com.ruoyi.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.zjsgfa.domain.SjLjsm;
import com.ruoyi.project.zjsgfa.service.ISjLjsmService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 设计信息-邻井扫描Controller
 * 
 * @author ruoyi
 * @date 2025-07-22
 */
@RestController
@RequestMapping("/system/sjLjsm")
public class SjLjsmController extends BaseController
{
    @Autowired
    private ISjLjsmService sjLjsmService;

    /**
     * 查询设计信息-邻井扫描列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjLjsm:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjLjsm sjLjsm)
    {
        startPage();
        List<SjLjsm> list = sjLjsmService.selectSjLjsmList(sjLjsm);
        return getDataTable(list);
    }

    /**
     * 导出设计信息-邻井扫描列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjLjsm:export')")
    @Log(title = "设计信息-邻井扫描", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjLjsm sjLjsm)
    {
        List<SjLjsm> list = sjLjsmService.selectSjLjsmList(sjLjsm);
        ExcelUtil<SjLjsm> util = new ExcelUtil<SjLjsm>(SjLjsm.class);
        util.exportExcel(response, list, "设计信息-邻井扫描数据");
    }

    /**
     * 获取设计信息-邻井扫描详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjLjsm:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjLjsmService.selectSjLjsmById(id));
    }

    /**
     * 新增设计信息-邻井扫描
     */
    //@PreAuthorize("@ss.hasPermi('system:sjLjsm:add')")
    @Log(title = "设计信息-邻井扫描", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjLjsm sjLjsm)
    {
        return toAjax(sjLjsmService.insertSjLjsm(sjLjsm));
    }

    /**
     * 修改设计信息-邻井扫描
     */
    //@PreAuthorize("@ss.hasPermi('system:sjLjsm:edit')")
    @Log(title = "设计信息-邻井扫描", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjLjsm sjLjsm)
    {
        return toAjax(sjLjsmService.updateSjLjsm(sjLjsm));
    }

    /**
     * 删除设计信息-邻井扫描
     */
    //@PreAuthorize("@ss.hasPermi('system:sjLjsm:remove')")
    @Log(title = "设计信息-邻井扫描", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjLjsmService.deleteSjLjsmByIds(ids));
    }
}
