package com.ruoyi.project.zjsgfa.service.impl;

import java.util.List;
import com.ruoyi.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.zjsgfa.mapper.SjZlyqZbyqMapper;
import com.ruoyi.project.zjsgfa.domain.SjZlyqZbyq;
import com.ruoyi.project.zjsgfa.service.ISjZlyqZbyqService;

/**
 * 设计信息-中靶要求-定向井Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-07-17
 */
@Service
public class SjZlyqZbyqServiceImpl implements ISjZlyqZbyqService 
{
    @Autowired
    private SjZlyqZbyqMapper sjZlyqZbyqMapper;

    /**
     * 查询设计信息-中靶要求-定向井
     * 
     * @param id 设计信息-中靶要求-定向井主键
     * @return 设计信息-中靶要求-定向井
     */
    @Override
    public SjZlyqZbyq selectSjZlyqZbyqById(Long id)
    {
        return sjZlyqZbyqMapper.selectSjZlyqZbyqById(id);
    }

    /**
     * 查询设计信息-中靶要求-定向井列表
     * 
     * @param sjZlyqZbyq 设计信息-中靶要求-定向井
     * @return 设计信息-中靶要求-定向井
     */
    @Override
    public List<SjZlyqZbyq> selectSjZlyqZbyqList(SjZlyqZbyq sjZlyqZbyq)
    {
        return sjZlyqZbyqMapper.selectSjZlyqZbyqList(sjZlyqZbyq);
    }

    /**
     * 新增设计信息-中靶要求-定向井
     * 
     * @param sjZlyqZbyq 设计信息-中靶要求-定向井
     * @return 结果
     */
    @Override
    public int insertSjZlyqZbyq(SjZlyqZbyq sjZlyqZbyq)
    {
        return sjZlyqZbyqMapper.insertSjZlyqZbyq(sjZlyqZbyq);
    }

    /**
     * 修改设计信息-中靶要求-定向井
     * 
     * @param sjZlyqZbyq 设计信息-中靶要求-定向井
     * @return 结果
     */
    @Override
    public int updateSjZlyqZbyq(SjZlyqZbyq sjZlyqZbyq)
    {
        sjZlyqZbyq.setUpdateTime(DateUtils.getNowDate());
        return sjZlyqZbyqMapper.updateSjZlyqZbyq(sjZlyqZbyq);
    }

    /**
     * 批量删除设计信息-中靶要求-定向井
     * 
     * @param ids 需要删除的设计信息-中靶要求-定向井主键
     * @return 结果
     */
    @Override
    public int deleteSjZlyqZbyqByIds(Long[] ids)
    {
        return sjZlyqZbyqMapper.deleteSjZlyqZbyqByIds(ids);
    }

    /**
     * 删除设计信息-中靶要求-定向井信息
     * 
     * @param id 设计信息-中靶要求-定向井主键
     * @return 结果
     */
    @Override
    public int deleteSjZlyqZbyqById(Long id)
    {
        return sjZlyqZbyqMapper.deleteSjZlyqZbyqById(id);
    }
}
