package com.ruoyi.project.zjsgfa.service.impl;

import java.util.List;

import cn.hutool.core.codec.Base64;
import com.ruoyi.common.utils.DateUtils;
import com.ruoyi.common.utils.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.zjsgfa.mapper.SjFlMapper;
import com.ruoyi.project.zjsgfa.domain.SjFl;
import com.ruoyi.project.zjsgfa.service.ISjFlService;

/**
 * 设计-附录Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-07-25
 */
@Service
public class SjFlServiceImpl implements ISjFlService 
{
    @Autowired
    private SjFlMapper sjFlMapper;

    /**
     * 查询设计-附录
     * 
     * @param id 设计-附录主键
     * @return 设计-附录
     */
    @Override
    public SjFl selectSjFlById(Long id)
    {
        return sjFlMapper.selectSjFlById(id);
    }

    /**
     * 查询设计-附录列表
     * 
     * @param sjFl 设计-附录
     * @return 设计-附录
     */
    @Override
    public List<SjFl> selectSjFlList(SjFl sjFl)
    {
        return sjFlMapper.selectSjFlList(sjFl);
    }

    /**
     * 新增设计-附录
     * 
     * @param sjFl 设计-附录
     * @return 结果
     */
    @Override
    public int insertSjFl(SjFl sjFl)
    {
        if(StringUtils.isNotEmpty(sjFl.getWjsgcs())){
            sjFl.setWjsgcs(new String(Base64.decode(sjFl.getWjsgcs())));
        }
        if(StringUtils.isNotEmpty(sjFl.getYfgkcs())){
            sjFl.setYfgkcs(new String(Base64.decode(sjFl.getYfgkcs())));
        }

        if(StringUtils.isNotEmpty(sjFl.getSyzn())){
            sjFl.setSyzn(new String(Base64.decode(sjFl.getSyzn())));
        }

        if(StringUtils.isNotEmpty(sjFl.getTsyxzs())){
            sjFl.setTsyxzs(new String(Base64.decode(sjFl.getTsyxzs())));
        }

        if(StringUtils.isNotEmpty(sjFl.getYjlxfs())){
            sjFl.setYjlxfs(new String(Base64.decode(sjFl.getYjlxfs())));
        }
        return sjFlMapper.insertSjFl(sjFl);
    }

    /**
     * 修改设计-附录
     * 
     * @param sjFl 设计-附录
     * @return 结果
     */
    @Override
    public int updateSjFl(SjFl sjFl)
    {
        if(StringUtils.isNotEmpty(sjFl.getWjsgcs())){
            sjFl.setWjsgcs(new String(Base64.decode(sjFl.getWjsgcs())));
        }
        if(StringUtils.isNotEmpty(sjFl.getYfgkcs())){
            sjFl.setYfgkcs(new String(Base64.decode(sjFl.getYfgkcs())));
        }

        if(StringUtils.isNotEmpty(sjFl.getSyzn())){
            sjFl.setSyzn(new String(Base64.decode(sjFl.getSyzn())));
        }

        if(StringUtils.isNotEmpty(sjFl.getTsyxzs())){
            sjFl.setTsyxzs(new String(Base64.decode(sjFl.getTsyxzs())));
        }

        if(StringUtils.isNotEmpty(sjFl.getYjlxfs())){
            sjFl.setYjlxfs(new String(Base64.decode(sjFl.getYjlxfs())));
        }
        sjFl.setUpdateTime(DateUtils.getNowDate());
        return sjFlMapper.updateSjFl(sjFl);
    }

    /**
     * 批量删除设计-附录
     * 
     * @param ids 需要删除的设计-附录主键
     * @return 结果
     */
    @Override
    public int deleteSjFlByIds(Long[] ids)
    {
        return sjFlMapper.deleteSjFlByIds(ids);
    }

    /**
     * 删除设计-附录信息
     * 
     * @param id 设计-附录主键
     * @return 结果
     */
    @Override
    public int deleteSjFlById(Long id)
    {
        return sjFlMapper.deleteSjFlById(id);
    }
}
