package com.ruoyi.project.zjsgfa.service.impl;

import java.lang.reflect.Field;
import java.util.*;
import java.util.stream.Collectors;

import com.ruoyi.project.zjsgfa.domain.SjSggyZjyFdxnb;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ruoyi.project.zjsgfa.mapper.SjFdsgcsZjyFdxnbMapper;
import com.ruoyi.project.zjsgfa.domain.SjFdsgcsZjyFdxnb;
import com.ruoyi.project.zjsgfa.service.ISjFdsgcsZjyFdxnbService;

/**
 * 设计信息-分段施工措施-分段钻井液性能设计Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-08-20
 */
@Service
public class SjFdsgcsZjyFdxnbServiceImpl implements ISjFdsgcsZjyFdxnbService 
{
    @Autowired
    private SjFdsgcsZjyFdxnbMapper sjFdsgcsZjyFdxnbMapper;

    /**
     * 查询设计信息-分段施工措施-分段钻井液性能设计
     * 
     * @param id 设计信息-分段施工措施-分段钻井液性能设计主键
     * @return 设计信息-分段施工措施-分段钻井液性能设计
     */
    @Override
    public SjFdsgcsZjyFdxnb selectSjFdsgcsZjyFdxnbById(Long id)
    {
        return sjFdsgcsZjyFdxnbMapper.selectSjFdsgcsZjyFdxnbById(id);
    }

    /**
     * 查询设计信息-分段施工措施-分段钻井液性能设计列表
     * 
     * @param sjFdsgcsZjyFdxnb 设计信息-分段施工措施-分段钻井液性能设计
     * @return 设计信息-分段施工措施-分段钻井液性能设计
     */
    @Override
    public Map<String, Object> selectSjFdsgcsZjyFdxnbList(SjFdsgcsZjyFdxnb sjFdsgcsZjyFdxnb)
    {
        List<SjFdsgcsZjyFdxnb> list = sjFdsgcsZjyFdxnbMapper.selectSjFdsgcsZjyFdxnbList(sjFdsgcsZjyFdxnb);

        List<Map<String, String>> fixedItems = Arrays.asList(
                new HashMap<String, String>() {{ put("name", "密度(g/cm³)"); put("field", "md"); }},
                new HashMap<String, String>() {{ put("name", "马氏漏斗黏度(s)"); put("field", "msldnd"); }},
                new HashMap<String, String>() {{ put("name", "API滤失量(ml)"); put("field", "apilsl"); }},
                new HashMap<String, String>() {{ put("name", "API泥饼(mm)"); put("field", "apinb"); }},
                new HashMap<String, String>() {{ put("name", "静切力(Pa)"); put("field", "jql"); }},
                new HashMap<String, String>() {{ put("name", "pH值"); put("field", "ph"); }},
                new HashMap<String, String>() {{ put("name", "含砂量(%)"); put("field", "hsl"); }},
                new HashMap<String, String>() {{ put("name", "总固含(%)"); put("field", "zgh"); }},
                new HashMap<String, String>() {{ put("name", "摩阻系数"); put("field", "mzxs"); }},
                new HashMap<String, String>() {{ put("name", "动切力(Pa)"); put("field", "dql"); }},
                new HashMap<String, String>() {{ put("name", "塑性黏度(mPa·s)"); put("field", "sxnd"); }}
        );

        // 提取井段（去重，按顺序排列）
        List<String> wellSegments = list.stream()
                .map(SjFdsgcsZjyFdxnb::getJd)
                .distinct()
                .collect(Collectors.toList());

        // 表格数据：每行对应一个固定项目，每列对应一个井段
        List<Map<String, String>> tableData = new ArrayList<>();

        for (Map<String, String> item : fixedItems) {
            String itemName = item.get("name"); // 项目名称（如"密度(g/cm³)"）
            String fieldName = item.get("field"); // 实体类字段名（如"md"）

            Map<String, String> row = new HashMap<>();
            row.put("项目", itemName); // 第一列固定为项目名称
            row.put("field", fieldName); // 第一列固定为项目名称

            // 遍历每个井段，填充对应字段的值
            for (String segment : wellSegments) {
                // 找到当前井段的数据对象
                SjFdsgcsZjyFdxnb segmentData = list.stream()
                        .filter(d -> segment.equals(d.getJd()))
                        .findFirst()
                        .orElse(null);

                // 通过反射获取字段值（避免大量if-else）
                String value = "";
                if (segmentData != null) {
                    try {
                        Field field = SjFdsgcsZjyFdxnb.class.getDeclaredField(fieldName);
                        field.setAccessible(true);
                        Object fieldValue = field.get(segmentData);
                        value = fieldValue != null ? fieldValue.toString() : "";
                    } catch (Exception e) {
                        value = "";
                    }
                }
                row.put(segment, value); // 列名为井段，值为字段值
            }
            tableData.add(row);
        }

        Map<String,Object> map =new HashMap<>();
        map.put("jds",wellSegments);
        map.put("data",tableData);
        return map;
    }

    /**
     * 新增设计信息-分段施工措施-分段钻井液性能设计
     * 
     * @param sjFdsgcsZjyFdxnb 设计信息-分段施工措施-分段钻井液性能设计
     * @return 结果
     */
    @Override
    public int insertSjFdsgcsZjyFdxnb(SjFdsgcsZjyFdxnb sjFdsgcsZjyFdxnb)
    {
        return sjFdsgcsZjyFdxnbMapper.insertSjFdsgcsZjyFdxnb(sjFdsgcsZjyFdxnb);
    }

    /**
     * 修改设计信息-分段施工措施-分段钻井液性能设计
     * 
     * @param sjFdsgcsZjyFdxnb 设计信息-分段施工措施-分段钻井液性能设计
     * @return 结果
     */
    @Override
    public int updateSjFdsgcsZjyFdxnb(SjFdsgcsZjyFdxnb sjFdsgcsZjyFdxnb)
    {
        return sjFdsgcsZjyFdxnbMapper.updateSjFdsgcsZjyFdxnb(sjFdsgcsZjyFdxnb);
    }

    /**
     * 批量删除设计信息-分段施工措施-分段钻井液性能设计
     * 
     * @param ids 需要删除的设计信息-分段施工措施-分段钻井液性能设计主键
     * @return 结果
     */
    @Override
    public int deleteSjFdsgcsZjyFdxnbByIds(Long[] ids)
    {
        return sjFdsgcsZjyFdxnbMapper.deleteSjFdsgcsZjyFdxnbByIds(ids);
    }

    /**
     * 删除设计信息-分段施工措施-分段钻井液性能设计信息
     * 
     * @param id 设计信息-分段施工措施-分段钻井液性能设计主键
     * @return 结果
     */
    @Override
    public int deleteSjFdsgcsZjyFdxnbById(Long id)
    {
        return sjFdsgcsZjyFdxnbMapper.deleteSjFdsgcsZjyFdxnbById(id);
    }
}
