package com.ruoyi.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ruoyi.framework.aspectj.lang.annotation.Excel;
import com.ruoyi.framework.web.domain.BaseEntity;

/**
 * 设计信息-钻井液材料加量对象 sj_zjy_cljl
 * 
 * @author ruoyi
 * @date 2025-07-17
 */
@Data
public class SjZjyCljl extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 材料名称及代号 */
    @Excel(name = "材料名称及代号")
    private String clmc;

    /** 一开加量 （kg/m3） */
    @Excel(name = "一开加量 ", readConverterExp = "k=g/m3")
    private String ykjl;

    /** 二开加量 （kg/m3） */
    @Excel(name = "二开加量 ", readConverterExp = "k=g/m3")
    private String ekjl;

    /** 三开加量 （kg/m3） */
    @Excel(name = "三开加量 ", readConverterExp = "k=g/m3")
    private String skjl;

    /** 四开加量 （kg/m3） */
    @Excel(name = "四开加量 ", readConverterExp = "k=g/m3")
    private String sikjl;

    /** 五开加量 （kg/m3） */
    @Excel(name = "五开加量 ", readConverterExp = "k=g/m3")
    private String wkjl;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    private Integer num;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setJh(String jh) 
    {
        this.jh = jh;
    }

    public String getJh() 
    {
        return jh;
    }

    public void setClmc(String clmc) 
    {
        this.clmc = clmc;
    }

    public String getClmc() 
    {
        return clmc;
    }

    public void setYkjl(String ykjl) 
    {
        this.ykjl = ykjl;
    }

    public String getYkjl() 
    {
        return ykjl;
    }

    public void setEkjl(String ekjl) 
    {
        this.ekjl = ekjl;
    }

    public String getEkjl() 
    {
        return ekjl;
    }

    public void setSkjl(String skjl) 
    {
        this.skjl = skjl;
    }

    public String getSkjl() 
    {
        return skjl;
    }

    public void setSikjl(String sikjl) 
    {
        this.sikjl = sikjl;
    }

    public String getSikjl() 
    {
        return sikjl;
    }

    public void setWkjl(String wkjl) 
    {
        this.wkjl = wkjl;
    }

    public String getWkjl() 
    {
        return wkjl;
    }

    public void setBz(String bz) 
    {
        this.bz = bz;
    }

    public String getBz() 
    {
        return bz;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("id", getId())
            .append("jh", getJh())
            .append("clmc", getClmc())
            .append("ykjl", getYkjl())
            .append("ekjl", getEkjl())
            .append("skjl", getSkjl())
            .append("sikjl", getSikjl())
            .append("wkjl", getWkjl())
            .append("bz", getBz())
            .append("createdBy", getCreatedBy())
            .append("createdTime", getCreatedTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
