package com.ruoyi.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ruoyi.framework.aspectj.lang.annotation.Log;
import com.ruoyi.framework.aspectj.lang.enums.BusinessType;
import com.ruoyi.project.zjsgfa.domain.SjDzfc;
import com.ruoyi.project.zjsgfa.service.ISjDzfcService;
import com.ruoyi.framework.web.controller.BaseController;
import com.ruoyi.framework.web.domain.AjaxResult;
import com.ruoyi.common.utils.poi.ExcelUtil;
import com.ruoyi.framework.web.page.TableDataInfo;

/**
 * 地质分层Controller
 * 
 * @author ruoyi
 * @date 2025-07-07
 */
@RestController
@RequestMapping("/system/sjDzfc")
public class SjDzfcController extends BaseController
{
    @Autowired
    private ISjDzfcService sjDzfcService;

    /**
     * 查询地质分层列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDzfc:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjDzfc sjDzfc)
    {
//        startPage();
        List<SjDzfc> list = sjDzfcService.selectSjDzfcList(sjDzfc);
        return getDataTable(list);
    }

    /**
     * 导出地质分层列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDzfc:export')")
    @Log(title = "地质分层", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjDzfc sjDzfc)
    {
        List<SjDzfc> list = sjDzfcService.selectSjDzfcList(sjDzfc);
        ExcelUtil<SjDzfc> util = new ExcelUtil<SjDzfc>(SjDzfc.class);
        util.exportExcel(response, list, "地质分层数据");
    }

    /**
     * 获取地质分层详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDzfc:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjDzfcService.selectSjDzfcById(id));
    }

    /**
     * 新增地质分层
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDzfc:add')")
    @Log(title = "地质分层", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjDzfc sjDzfc)
    {
        return toAjax(sjDzfcService.insertSjDzfc(sjDzfc));
    }

    /**
     * 修改地质分层
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDzfc:edit')")
    @Log(title = "地质分层", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjDzfc sjDzfc)
    {
        return toAjax(sjDzfcService.updateSjDzfc(sjDzfc));
    }

    /**
     * 删除地质分层
     */
    //@PreAuthorize("@ss.hasPermi('system:sjDzfc:remove')")
    @Log(title = "地质分层", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjDzfcService.deleteSjDzfcByIds(ids));
    }
}
