package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.MxglpzMapper;
import com.zjsgfa.project.zjsgfa.domain.Mxglpz;
import com.zjsgfa.project.zjsgfa.service.IMxglpzService;

/**
 * 模型关联配置Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-09-29
 */
@Service
public class MxglpzServiceImpl implements IMxglpzService 
{
    @Autowired
    private MxglpzMapper mxglpzMapper;

    /**
     * 查询模型关联配置
     * 
     * @param id 模型关联配置主键
     * @return 模型关联配置
     */
    @Override
    public Mxglpz selectMxglpzById(Long id)
    {
        return mxglpzMapper.selectMxglpzById(id);
    }

    /**
     * 查询模型关联配置列表
     * 
     * @param mxglpz 模型关联配置
     * @return 模型关联配置
     */
    @Override
    public List<Mxglpz> selectMxglpzList(Mxglpz mxglpz)
    {
        return mxglpzMapper.selectMxglpzList(mxglpz);
    }

    /**
     * 新增模型关联配置
     * 
     * @param mxglpz 模型关联配置
     * @return 结果
     */
    @Override
    public int insertMxglpz(Mxglpz mxglpz)
    {
        return mxglpzMapper.insertMxglpz(mxglpz);
    }

    /**
     * 修改模型关联配置
     * 
     * @param mxglpz 模型关联配置
     * @return 结果
     */
    @Override
    public int updateMxglpz(Mxglpz mxglpz)
    {
        mxglpz.setUpdateTime(DateUtils.getNowDate());
        return mxglpzMapper.updateMxglpz(mxglpz);
    }

    /**
     * 批量删除模型关联配置
     * 
     * @param ids 需要删除的模型关联配置主键
     * @return 结果
     */
    @Override
    public int deleteMxglpzByIds(Long[] ids)
    {
        return mxglpzMapper.deleteMxglpzByIds(ids);
    }

    /**
     * 删除模型关联配置信息
     * 
     * @param id 模型关联配置主键
     * @return 结果
     */
    @Override
    public int deleteMxglpzById(Long id)
    {
        return mxglpzMapper.deleteMxglpzById(id);
    }
}
