package com.zjsgfa.project.zjsgfa.mapper;

import java.util.List;
import com.zjsgfa.project.zjsgfa.domain.CommonFile;

/**
 * 文件Mapper接口
 * 
 * @author ruoyi
 * @date 2025-10-27
 */
public interface CommonFileMapper 
{
    /**
     * 查询文件
     * 
     * @param id 文件主键
     * @return 文件
     */
    public CommonFile selectCommonFileById(Long id);

    /**
     * 查询文件列表
     * 
     * @param commonFile 文件
     * @return 文件集合
     */
    public List<CommonFile> selectCommonFileList(CommonFile commonFile);

    /**
     * 新增文件
     * 
     * @param commonFile 文件
     * @return 结果
     */
    public int insertCommonFile(CommonFile commonFile);

    /**
     * 修改文件
     * 
     * @param commonFile 文件
     * @return 结果
     */
    public int updateCommonFile(CommonFile commonFile);

    /**
     * 删除文件
     * 
     * @param id 文件主键
     * @return 结果
     */
    public int deleteCommonFileById(Long id);

    /**
     * 批量删除文件
     * 
     * @param ids 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteCommonFileByIds(Long[] ids);

    int deleteCommonFileByICommonFile(CommonFile upFile);

}
