package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;
import lombok.Data;

/**
 * 常量-岩性数据对象 cl_yxsj
 * 
 * @author ruoyi
 * @date 2025-09-22
 */
@Data
public class ClYxsj extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 地质分层 */
    @Excel(name = "地质分层")
    private String dzfc;

    /** 地层代号 */
    @Excel(name = "地层代号")
    private String dcdh;

    /** 接触面 */
    @Excel(name = "接触面")
    private String jcm;

    /** 主要岩性 */
    @Excel(name = "主要岩性")
    private String zyyx;

    /** 岩性描述 */
    @Excel(name = "岩性描述")
    private String yxms;

    /** 特殊岩性 */
    @Excel(name = "特殊岩性")
    private String tsyx;

    /** 最小厚度 */
    @Excel(name = "最小厚度")
    private String zxhd;

    /** 最大厚度 */
    @Excel(name = "最大厚度")
    private String zdhd;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

    private List<ClYxsj> list;

    public void setId(Long id) 
    {
        this.id = id;
    }

    public Long getId() 
    {
        return id;
    }

    public void setDzfc(String dzfc) 
    {
        this.dzfc = dzfc;
    }

    public String getDzfc() 
    {
        return dzfc;
    }

    public void setDcdh(String dcdh) 
    {
        this.dcdh = dcdh;
    }

    public String getDcdh() 
    {
        return dcdh;
    }

    public void setJcm(String jcm) 
    {
        this.jcm = jcm;
    }

    public String getJcm() 
    {
        return jcm;
    }

    public void setZyyx(String zyyx) 
    {
        this.zyyx = zyyx;
    }

    public String getZyyx() 
    {
        return zyyx;
    }

    public void setYxms(String yxms) 
    {
        this.yxms = yxms;
    }

    public String getYxms() 
    {
        return yxms;
    }

    public void setTsyx(String tsyx) 
    {
        this.tsyx = tsyx;
    }

    public String getTsyx() 
    {
        return tsyx;
    }

    public void setZxhd(String zxhd) 
    {
        this.zxhd = zxhd;
    }

    public String getZxhd() 
    {
        return zxhd;
    }

    public void setZdhd(String zdhd) 
    {
        this.zdhd = zdhd;
    }

    public String getZdhd() 
    {
        return zdhd;
    }

    public void setBz(String bz) 
    {
        this.bz = bz;
    }

    public String getBz() 
    {
        return bz;
    }

    public void setCreatedBy(String createdBy) 
    {
        this.createdBy = createdBy;
    }

    public String getCreatedBy() 
    {
        return createdBy;
    }

    public void setCreatedTime(Date createdTime) 
    {
        this.createdTime = createdTime;
    }

    public Date getCreatedTime() 
    {
        return createdTime;
    }


}
