package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjFdsgcsDcyx;
import com.zjsgfa.project.zjsgfa.service.ISjFdsgcsDcyxService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计-分段施工措施-地层岩性Controller
 * 
 * @author
 * @date 2025-08-06
 */
@RestController
@RequestMapping("/system/sjFdsgcsDcyx")
public class SjFdsgcsDcyxController extends BaseController
{
    @Autowired
    private ISjFdsgcsDcyxService sjFdsgcsDcyxService;

    /**
     * 查询设计-分段施工措施-地层岩性列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcyx:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjFdsgcsDcyx sjFdsgcsDcyx)
    {
//        startPage();
        List<SjFdsgcsDcyx> list = sjFdsgcsDcyxService.selectSjFdsgcsDcyxList(sjFdsgcsDcyx);
        return getDataTable(list);
    }

    /**
     * 导出设计-分段施工措施-地层岩性列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcyx:export')")
    @Log(title = "设计-分段施工措施-地层岩性", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjFdsgcsDcyx sjFdsgcsDcyx)
    {
        List<SjFdsgcsDcyx> list = sjFdsgcsDcyxService.selectSjFdsgcsDcyxList(sjFdsgcsDcyx);
        ExcelUtil<SjFdsgcsDcyx> util = new ExcelUtil<SjFdsgcsDcyx>(SjFdsgcsDcyx.class);
        util.exportExcel(response, list, "设计-分段施工措施-地层岩性数据");
    }

    /**
     * 获取设计-分段施工措施-地层岩性详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcyx:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjFdsgcsDcyxService.selectSjFdsgcsDcyxById(id));
    }

    /**
     * 新增设计-分段施工措施-地层岩性
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcyx:add')")
    @Log(title = "设计-分段施工措施-地层岩性", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjFdsgcsDcyx sjFdsgcsDcyx)
    {
        return toAjax(sjFdsgcsDcyxService.insertSjFdsgcsDcyx(sjFdsgcsDcyx));
    }

    /**
     * 修改设计-分段施工措施-地层岩性
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcyx:edit')")
    @Log(title = "设计-分段施工措施-地层岩性", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjFdsgcsDcyx sjFdsgcsDcyx)
    {
        return toAjax(sjFdsgcsDcyxService.updateSjFdsgcsDcyx(sjFdsgcsDcyx));
    }

    /**
     * 删除设计-分段施工措施-地层岩性
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcyx:remove')")
    @Log(title = "设计-分段施工措施-地层岩性", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjFdsgcsDcyxService.deleteSjFdsgcsDcyxByIds(ids));
    }
}
