package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SgfambTjpz;
import com.zjsgfa.project.zjsgfa.service.ISgfambTjpzService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 施工方案模板-条件配置Controller
 * 
 * @author ruoyi
 * @date 2025-09-25
 */
@RestController
@RequestMapping("/system/sgfambTjpz")
public class SgfambTjpzController extends BaseController
{
    @Autowired
    private ISgfambTjpzService sgfambTjpzService;

    /**
     * 查询施工方案模板-条件配置列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfambTjpz:list')")
    @GetMapping("/list")
    public TableDataInfo list(SgfambTjpz sgfambTjpz)
    {
        startPage();
        List<SgfambTjpz> list = sgfambTjpzService.selectSgfambTjpzList(sgfambTjpz);
        return getDataTable(list);
    }

    @GetMapping("/selectList")
    public TableDataInfo selectList(SgfambTjpz sgfambTjpz)
    {
//        startPage();
        List<SgfambTjpz> list = sgfambTjpzService.selectSgfambTjpzList(sgfambTjpz);
        return getDataTable(list);
    }

    /**
     * 导出施工方案模板-条件配置列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfambTjpz:export')")
    @Log(title = "施工方案模板-条件配置", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SgfambTjpz sgfambTjpz)
    {
        List<SgfambTjpz> list = sgfambTjpzService.selectSgfambTjpzList(sgfambTjpz);
        ExcelUtil<SgfambTjpz> util = new ExcelUtil<SgfambTjpz>(SgfambTjpz.class);
        util.exportExcel(response, list, "施工方案模板-条件配置数据");
    }

    /**
     * 获取施工方案模板-条件配置详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfambTjpz:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sgfambTjpzService.selectSgfambTjpzById(id));
    }

    /**
     * 新增施工方案模板-条件配置
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfambTjpz:add')")
    @Log(title = "施工方案模板-条件配置", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SgfambTjpz sgfambTjpz)
    {
        return toAjax(sgfambTjpzService.insertSgfambTjpz(sgfambTjpz));
    }

    /**
     * 修改施工方案模板-条件配置
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfambTjpz:edit')")
    @Log(title = "施工方案模板-条件配置", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SgfambTjpz sgfambTjpz)
    {
        return toAjax(sgfambTjpzService.updateSgfambTjpz(sgfambTjpz));
    }

    /**
     * 删除施工方案模板-条件配置
     */
    //@PreAuthorize("@ss.hasPermi('system:sgfambTjpz:remove')")
    @Log(title = "施工方案模板-条件配置", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sgfambTjpzService.deleteSgfambTjpzByIds(ids));
    }
}
