package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import com.zjsgfa.common.exception.job.TaskException;
import com.zjsgfa.common.utils.StringUtils;
import com.zjsgfa.project.monitor.domain.SysJob;
import com.zjsgfa.project.monitor.service.ISysJobService;
import com.zjsgfa.project.zjsgfa.domain.MxfxjgbTsc;
import com.zjsgfa.project.zjsgfa.domain.SjDjjc;
import com.zjsgfa.project.zjsgfa.mapper.MxfxjgbTscMapper;
import com.zjsgfa.project.zjsgfa.mapper.SjDjjcMapper;
import oracle.jdbc.proxy.annotation.Post;
import org.quartz.SchedulerException;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.Mxfxjgb;
import com.zjsgfa.project.zjsgfa.service.IMxfxjgbService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 大模型分析Controller
 * 
 * @author ruoyi
 * @date 2025-10-22
 */
@RestController
@RequestMapping("/system/mxfxjgb")
public class MxfxjgbController extends BaseController
{
    @Autowired
    private IMxfxjgbService mxfxjgbService;

    @Autowired
    private ISysJobService jobService;

    @Autowired
    private MxfxjgbTscMapper mxfxjgbTscMapper;

    @Autowired
    private SjDjjcMapper sjDjjcMapper;

    /**
     * 查询大模型分析列表
     */
    //@PreAuthorize("@ss.hasPermi('system:mxfxjgb:list')")
    @GetMapping("/list")
    public TableDataInfo list(Mxfxjgb mxfxjgb)
    {
        startPage();
        List<Mxfxjgb> list = mxfxjgbService.selectMxfxjgbList(mxfxjgb);
        return getDataTable(list);
    }

    /**
     * 导出大模型分析列表
     */
    //@PreAuthorize("@ss.hasPermi('system:mxfxjgb:export')")
    @Log(title = "大模型分析", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, Mxfxjgb mxfxjgb)
    {
        List<Mxfxjgb> list = mxfxjgbService.selectMxfxjgbList(mxfxjgb);
        ExcelUtil<Mxfxjgb> util = new ExcelUtil<Mxfxjgb>(Mxfxjgb.class);
        util.exportExcel(response, list, "大模型分析数据");
    }

    /**
     * 获取大模型分析详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:mxfxjgb:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(mxfxjgbService.selectMxfxjgbById(id));
    }

    /**
     * 新增大模型分析
     */
    //@PreAuthorize("@ss.hasPermi('system:mxfxjgb:add')")
    @Log(title = "大模型分析", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody Mxfxjgb mxfxjgb) throws SchedulerException, TaskException {
        return toAjax(mxfxjgbService.insertMxfxjgb(mxfxjgb));
    }

    /**
     * 修改大模型分析
     */
    //@PreAuthorize("@ss.hasPermi('system:mxfxjgb:edit')")
    @Log(title = "大模型分析", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody Mxfxjgb mxfxjgb)
    {

        return toAjax(mxfxjgbService.updateMxfxjgb(mxfxjgb));
    }

    /**
     * 删除大模型分析
     */
    //@PreAuthorize("@ss.hasPermi('system:mxfxjgb:remove')")
    @Log(title = "大模型分析", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(mxfxjgbService.deleteMxfxjgbByIds(ids));
    }


    @GetMapping("/run/{id}")
    public AjaxResult run(@PathVariable("id") Long id) throws SchedulerException
    {
        boolean result=false;
        Mxfxjgb mxfxjgb1 = mxfxjgbService.selectMxfxjgbById(id);
        if(mxfxjgb1!=null){
            if(mxfxjgb1.getJobid()!=null){
                SysJob job = jobService.selectJobById(mxfxjgb1.getJobid());
                result = jobService.run(job);
                if(result){
                    mxfxjgb1.setJxzt("解析中");
                }else {
                    mxfxjgb1.setJxzt("解析失败");
                }
                mxfxjgbService.updateMxfxjgb(mxfxjgb1);
            }
        }

        return result ? success() : error("任务不存在或已过期！");
    }


    /**
     * 自动启动大模型
     * @param mxfxjgb
     * @return
     * @throws SchedulerException
     * @throws TaskException
     */
    @PostMapping("/zdrunAi")
    public AjaxResult zdrunAi(@RequestBody Mxfxjgb mxfxjgb) throws SchedulerException, TaskException {

        //查询方案名称
        if(StringUtils.isNotEmpty(mxfxjgb.getFaid())){
            SjDjjc sjDjjc = sjDjjcMapper.selectSjDjjcById(Long.parseLong(mxfxjgb.getFaid()));
            if(sjDjjc!=null){
                mxfxjgb.setFamc(sjDjjc.getJh()+"设计方案");
            }
        }
        //查询提示词
        MxfxjgbTsc mxfxjgbTsc=new MxfxjgbTsc();

        List<MxfxjgbTsc> mxfxjgbTscs = mxfxjgbTscMapper.selectMxfxjgbTscList(mxfxjgbTsc);

        if(StringUtils.isNotEmpty(mxfxjgb.getRwlx())){
            MxfxjgbTsc mxfxjgbTsc1 = mxfxjgbTscs.stream().filter(it -> it.getLb().equals(mxfxjgb.getRwlx())).findFirst().orElse(null);
            if(mxfxjgbTsc1!=null){
                mxfxjgb.setTsc(mxfxjgbTsc1.getTsc());
            }
        }
        int i = mxfxjgbService.insertMxfxjgb(mxfxjgb);

        boolean result=false;
        Mxfxjgb mxfxjgb1 = mxfxjgbService.selectMxfxjgbById(mxfxjgb.getId());
        if(mxfxjgb1!=null){
            if(mxfxjgb1.getJobid()!=null){
                SysJob job = jobService.selectJobById(mxfxjgb1.getJobid());
                result = jobService.run(job);
                if(result){
                    mxfxjgb1.setJxzt("解析中");
                }else {
                    mxfxjgb1.setJxzt("解析失败");
                }
                mxfxjgbService.updateMxfxjgb(mxfxjgb1);
            }
        }

        return result ? success() : error("任务不存在或已过期！");
    }


    /**
     * 锁定按钮
     * @param
     * @return
     */
    @GetMapping("/sd/{id}")
    public AjaxResult sd(@PathVariable Long id)
    {
        Mxfxjgb mxfxjgb1 = mxfxjgbService.selectMxfxjgbById(id);
        String faid = mxfxjgb1.getFaid();
        mxfxjgbService.updateMxfxjgbByFaid(faid);
        Mxfxjgb mxfxjgb = new Mxfxjgb();
        mxfxjgb.setSfsd("锁定");
        mxfxjgb.setId(id);
        return toAjax(mxfxjgbService.updateMxfxjgb(mxfxjgb));
    }

}
