package com.zjsgfa.project.zjsgfa.service.impl;

import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;

import cn.hutool.core.codec.Base64;
import com.zjsgfa.common.utils.DateUtils;
import com.zjsgfa.common.utils.StringUtils;
import com.zjsgfa.framework.util.RichTextProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.JcxxHseMapper;
import com.zjsgfa.project.zjsgfa.domain.JcxxHse;
import com.zjsgfa.project.zjsgfa.service.IJcxxHseService;

/**
 * 基础信息-HSE专篇Service业务层处理
 * 
 * @author
 * @date 2025-07-24
 */
@Service
public class JcxxHseServiceImpl implements IJcxxHseService 
{
    @Autowired
    private JcxxHseMapper jcxxHseMapper;

    /**
     * 查询基础信息-HSE专篇
     * 
     * @param id 基础信息-HSE专篇主键
     * @return 基础信息-HSE专篇
     */
    @Override
    public JcxxHse selectJcxxHseById(Long id)
    {
        JcxxHse jcxxHse = jcxxHseMapper.selectJcxxHseById(id);
        // 压缩富文本中的图片，设置质量和最大尺寸
        String compressedContent = RichTextProcessor.processRichText(
                jcxxHse.getHse(),  // 你的富文本字段
                0.7f,  // 质量 0.0-1.0
                800,   // 最大宽度
                600    // 最大高度
        );

        // 设置压缩后的富文本
        jcxxHse.setHse(compressedContent);
        return jcxxHse;
    }

    /**
     * 查询基础信息-HSE专篇列表
     * 
     * @param jcxxHse 基础信息-HSE专篇
     * @return 基础信息-HSE专篇
     */
    @Override
    public List<JcxxHse> selectJcxxHseList(JcxxHse jcxxHse)
    {
        List<JcxxHse> list = jcxxHseMapper.selectJcxxHseList(jcxxHse);
        list.stream().map(entity -> {
            // 压缩富文本中的图片，设置质量和最大尺寸
            String compressedContent = RichTextProcessor.processRichText(
                    entity.getHse(),  // 你的富文本字段
                    0.7f,  // 质量 0.0-1.0
                    800,   // 最大宽度
                    600    // 最大高度
            );

            // 设置压缩后的富文本
            entity.setHse(compressedContent);
            return entity;
        }).collect(Collectors.toList());

        return list;
    }

    /**
     * 新增基础信息-HSE专篇
     * 
     * @param jcxxHse 基础信息-HSE专篇
     * @return 结果
     */
    @Override
    public int insertJcxxHse(JcxxHse jcxxHse)
    {
        if(StringUtils.isNotEmpty(jcxxHse.getHse())){
            String s = new String(Base64.decode(jcxxHse.getHse()), StandardCharsets.UTF_8);
            jcxxHse.setHse(s);
        }
        return jcxxHseMapper.insertJcxxHse(jcxxHse);
    }

    /**
     * 修改基础信息-HSE专篇
     * 
     * @param jcxxHse 基础信息-HSE专篇
     * @return 结果
     */
    @Override
    public int updateJcxxHse(JcxxHse jcxxHse)
    {
        if(StringUtils.isNotEmpty(jcxxHse.getHse())){
            String s = new String(Base64.decode(jcxxHse.getHse()), StandardCharsets.UTF_8);
            jcxxHse.setHse(s);
        }
        jcxxHse.setUpdateTime(DateUtils.getNowDate());
        return jcxxHseMapper.updateJcxxHse(jcxxHse);
    }

    /**
     * 批量删除基础信息-HSE专篇
     * 
     * @param ids 需要删除的基础信息-HSE专篇主键
     * @return 结果
     */
    @Override
    public int deleteJcxxHseByIds(Long[] ids)
    {
        return jcxxHseMapper.deleteJcxxHseByIds(ids);
    }

    /**
     * 删除基础信息-HSE专篇信息
     * 
     * @param id 基础信息-HSE专篇主键
     * @return 结果
     */
    @Override
    public int deleteJcxxHseById(Long id)
    {
        return jcxxHseMapper.deleteJcxxHseById(id);
    }
}
