package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计信息-井身质量要求详细对象 sj_zlyq_xx
 * 
 * @author
 * @date 2025-07-17
 */
@Data
public class SjZlyqXx extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 定向井段井身质量要求 */
    @Excel(name = "定向井段井身质量要求")
    private String dxjzlyq;

    /** 固井质量要求 */
    @Excel(name = "固井质量要求")
    private String gjzlyq;

    /** 完成井井口质量要求 */
    @Excel(name = "完成井井口质量要求")
    private String wcjjkzlyq;

    /** 油气层污染判定要求 */
    @Excel(name = "油气层污染判定要求")
    private String yqcwrpdyq;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

}
