package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计信息-H2S对象 sj_h2s
 * 
 * @author
 * @date 2025-07-22
 */
@Data
public class SjH2s extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /**
     * 邻井井号
     */
    private String ljjh;

    /** 井深 */
    @Excel(name = "井深")
    private Double js;

    /** 工程状态 */
    @Excel(name = "工程状态")
    private String gczt;

    /** 层位 */
    @Excel(name = "层位")
    private String cw;

    /** 显示浓度 */
    @Excel(name = "显示浓度")
    private Double xsbd;

    /** 显示过程与处理 */
    @Excel(name = "显示过程与处理")
    private String xsgc;

    /** 检测时间 */
    @Excel(name = "检测时间")
    private String jcsj;

    /** 检测方法 */
    @Excel(name = "检测方法")
    private String jcfs;

    /** 方位（位于井口） */
    @Excel(name = "方位", readConverterExp = "位=于井口")
    private Double wyjkfw;

    /** 方位（位于井口） */
    @Excel(name = "方位", readConverterExp = "位=于井口")
    private Double wyjkjl;

    /** 方位（位于 A 靶点） */
    @Excel(name = "方位", readConverterExp = "位=于,A=,靶=点")
    private Double wybdfw;

    /** 方位（位于 A 靶点） */
    @Excel(name = "方位", readConverterExp = "位=于,A=,靶=点")
    private Double wybdjl;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;
}
