package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjFdsgcsDcyxt;
import com.zjsgfa.project.zjsgfa.service.ISjFdsgcsDcyxtService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 地层压力图Controller
 * 
 * @author ruoyi
 * @date 2025-12-09
 */
@RestController
@RequestMapping("/system/sjFdsgcsDcyxt")
public class SjFdsgcsDcyxtController extends BaseController
{
    @Autowired
    private ISjFdsgcsDcyxtService sjFdsgcsDcyxtService;

    /**
     * 查询地层压力图列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcyxt:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjFdsgcsDcyxt sjFdsgcsDcyxt)
    {
        startPage();
        List<SjFdsgcsDcyxt> list = sjFdsgcsDcyxtService.selectSjFdsgcsDcyxtList(sjFdsgcsDcyxt);
        return getDataTable(list);
    }

    /**
     * 导出地层压力图列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcyxt:export')")
    @Log(title = "地层压力图", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjFdsgcsDcyxt sjFdsgcsDcyxt)
    {
        List<SjFdsgcsDcyxt> list = sjFdsgcsDcyxtService.selectSjFdsgcsDcyxtList(sjFdsgcsDcyxt);
        ExcelUtil<SjFdsgcsDcyxt> util = new ExcelUtil<SjFdsgcsDcyxt>(SjFdsgcsDcyxt.class);
        util.exportExcel(response, list, "地层压力图数据");
    }

    /**
     * 获取地层压力图详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcyxt:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjFdsgcsDcyxtService.selectSjFdsgcsDcyxtById(id));
    }

    /**
     * 新增地层压力图
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcyxt:add')")
    @Log(title = "地层压力图", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjFdsgcsDcyxt sjFdsgcsDcyxt)
    {
        return toAjax(sjFdsgcsDcyxtService.insertSjFdsgcsDcyxt(sjFdsgcsDcyxt));
    }

    /**
     * 修改地层压力图
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcyxt:edit')")
    @Log(title = "地层压力图", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjFdsgcsDcyxt sjFdsgcsDcyxt)
    {
        return toAjax(sjFdsgcsDcyxtService.updateSjFdsgcsDcyxt(sjFdsgcsDcyxt));
    }

    /**
     * 删除地层压力图
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFdsgcsDcyxt:remove')")
    @Log(title = "地层压力图", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjFdsgcsDcyxtService.deleteSjFdsgcsDcyxtByIds(ids));
    }
}
