package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.Mxglpz;
import com.zjsgfa.project.zjsgfa.service.IMxglpzService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 模型关联配置Controller
 * 
 * @author ruoyi
 * @date 2025-09-29
 */
@RestController
@RequestMapping("/system/mxglpz")
public class MxglpzController extends BaseController
{
    @Autowired
    private IMxglpzService mxglpzService;

    /**
     * 查询模型关联配置列表
     */
    //@PreAuthorize("@ss.hasPermi('system:mxglpz:list')")
    @GetMapping("/list")
    public TableDataInfo list(Mxglpz mxglpz)
    {
        startPage();
        List<Mxglpz> list = mxglpzService.selectMxglpzList(mxglpz);
        return getDataTable(list);
    }

    /**
     * 导出模型关联配置列表
     */
    //@PreAuthorize("@ss.hasPermi('system:mxglpz:export')")
    @Log(title = "模型关联配置", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, Mxglpz mxglpz)
    {
        List<Mxglpz> list = mxglpzService.selectMxglpzList(mxglpz);
        ExcelUtil<Mxglpz> util = new ExcelUtil<Mxglpz>(Mxglpz.class);
        util.exportExcel(response, list, "模型关联配置数据");
    }

    /**
     * 获取模型关联配置详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:mxglpz:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(mxglpzService.selectMxglpzById(id));
    }

    /**
     * 新增模型关联配置
     */
    //@PreAuthorize("@ss.hasPermi('system:mxglpz:add')")
    @Log(title = "模型关联配置", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody Mxglpz mxglpz)
    {
        return toAjax(mxglpzService.insertMxglpz(mxglpz));
    }

    /**
     * 修改模型关联配置
     */
    //@PreAuthorize("@ss.hasPermi('system:mxglpz:edit')")
    @Log(title = "模型关联配置", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody Mxglpz mxglpz)
    {
        return toAjax(mxglpzService.updateMxglpz(mxglpz));
    }

    /**
     * 删除模型关联配置
     */
    //@PreAuthorize("@ss.hasPermi('system:mxglpz:remove')")
    @Log(title = "模型关联配置", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(mxglpzService.deleteMxglpzByIds(ids));
    }



}
