package com.zjsgfa.project.zjsgfa.service.impl;

import java.util.Date;
import java.util.List;
import com.zjsgfa.common.utils.DateUtils;
import com.zjsgfa.common.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.zjsgfa.project.zjsgfa.mapper.CxtjMapper;
import com.zjsgfa.project.zjsgfa.domain.Cxtj;
import com.zjsgfa.project.zjsgfa.service.ICxtjService;

/**
 * 查询条件Service业务层处理
 * 
 * @author ruoyi
 * @date 2025-09-12
 */
@Service
public class CxtjServiceImpl implements ICxtjService 
{
    @Autowired
    private CxtjMapper cxtjMapper;

    /**
     * 查询查询条件
     * 
     * @param id 查询条件主键
     * @return 查询条件
     */
    @Override
    public Cxtj selectCxtjById(Long id)
    {
        return cxtjMapper.selectCxtjById(id);
    }

    /**
     * 查询查询条件列表
     * 
     * @param cxtj 查询条件
     * @return 查询条件
     */
    @Override
    public List<Cxtj> selectCxtjList(Cxtj cxtj)
    {
        return cxtjMapper.selectCxtjList(cxtj);
    }

    /**
     * 新增查询条件
     * 
     * @param cxtj 查询条件
     * @return 结果
     */
    @Override
    public int insertCxtj(Cxtj cxtj)
    {
        cxtj.setCreatedBy(SecurityUtils.getUsername());
        cxtj.setCreatedTime(new Date());
        return cxtjMapper.insertCxtj(cxtj);
    }

    /**
     * 修改查询条件
     * 
     * @param cxtj 查询条件
     * @return 结果
     */
    @Override
    public int updateCxtj(Cxtj cxtj)
    {
        cxtj.setUpdateTime(DateUtils.getNowDate());
        cxtj.setUpdateBy(SecurityUtils.getUsername());
        return cxtjMapper.updateCxtj(cxtj);
    }

    /**
     * 批量删除查询条件
     * 
     * @param ids 需要删除的查询条件主键
     * @return 结果
     */
    @Override
    public int deleteCxtjByIds(Long[] ids)
    {
        return cxtjMapper.deleteCxtjByIds(ids);
    }

    /**
     * 删除查询条件信息
     * 
     * @param id 查询条件主键
     * @return 结果
     */
    @Override
    public int deleteCxtjById(Long id)
    {
        return cxtjMapper.deleteCxtjById(id);
    }
}
