package com.zjsgfa.project.zjsgfa.service;

import java.util.List;

import com.zjsgfa.common.exception.job.TaskException;
import com.zjsgfa.project.zjsgfa.domain.Mxfxjgb;
import org.quartz.SchedulerException;

/**
 * 大模型分析Service接口
 * 
 * @author ruoyi
 * @date 2025-10-22
 */
public interface IMxfxjgbService 
{
    /**
     * 查询大模型分析
     * 
     * @param id 大模型分析主键
     * @return 大模型分析
     */
    public Mxfxjgb selectMxfxjgbById(Long id);

    /**
     * 查询大模型分析列表
     * 
     * @param mxfxjgb 大模型分析
     * @return 大模型分析集合
     */
    public List<Mxfxjgb> selectMxfxjgbList(Mxfxjgb mxfxjgb);

    /**
     * 新增大模型分析
     * 
     * @param mxfxjgb 大模型分析
     * @return 结果
     */
    public int insertMxfxjgb(Mxfxjgb mxfxjgb) throws SchedulerException, TaskException;

    /**
     * 修改大模型分析
     * 
     * @param mxfxjgb 大模型分析
     * @return 结果
     */
    public int updateMxfxjgb(Mxfxjgb mxfxjgb);

    /**
     * 批量删除大模型分析
     * 
     * @param ids 需要删除的大模型分析主键集合
     * @return 结果
     */
    public int deleteMxfxjgbByIds(Long[] ids);

    /**
     * 删除大模型分析信息
     * 
     * @param id 大模型分析主键
     * @return 结果
     */
    public int deleteMxfxjgbById(Long id);
}
