package com.zjsgfa.project.zjsgfa.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.zjsgfa.framework.aspectj.lang.annotation.Excel;
import com.zjsgfa.framework.web.domain.BaseEntity;

/**
 * 设计信息-套管性能数据对象 sj_tg_tgxnsj
 * 
 * @author
 * @date 2025-07-17
 */
@Data
public class SjTgTgxnsj extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 井号 */
    @Excel(name = "井号")
    private String jh;

    /** 外径 */
    @Excel(name = "外径")
    private String wj;

    /** 钢级 */
    @Excel(name = "钢级")
    private String gj;

    /** 壁厚 */
    @Excel(name = "壁厚")
    private String bh;

    /** 扣型 */
    @Excel(name = "扣型")
    private String kx;

    /** 每米重量 */
    @Excel(name = "每米重量")
    private String mmzl;

    /** 接箍外径 */
    @Excel(name = "接箍外径")
    private String jgwj;

    /** 抗拉强度 */
    @Excel(name = "抗拉强度")
    private String klqd;

    /** 抗挤强度 */
    @Excel(name = "抗挤强度")
    private String kjqd;

    /** 抗内压强度 */
    @Excel(name = "抗内压强度")
    private String knyqd;

    /** 备注 */
    @Excel(name = "备注")
    private String bz;

    /** 创建人 */
    @Excel(name = "创建人")
    private String createdBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "创建时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date createdTime;

}
