package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjJkzp;
import com.zjsgfa.project.zjsgfa.service.ISjJkzpService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计-井控专篇Controller
 * 
 * @author
 * @date 2025-07-24
 */
@RestController
@RequestMapping("/system/sjJkzp")
public class SjJkzpController extends BaseController
{
    @Autowired
    private ISjJkzpService sjJkzpService;

    /**
     * 查询设计-井控专篇列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJkzp:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjJkzp sjJkzp)
    {
        startPage();
        List<SjJkzp> list = sjJkzpService.selectSjJkzpList(sjJkzp);
        return getDataTable(list);
    }

    @GetMapping("/getInfo")
    public AjaxResult getInfo(SjJkzp sjJkzp)
    {
        List<SjJkzp> list = sjJkzpService.selectSjJkzpList(sjJkzp);
        SjJkzp vo= new SjJkzp();
        if(list.size()>0){
            vo=list.get(0);
        }
        return AjaxResult.success(vo);
    }

    /**
     * 导出设计-井控专篇列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJkzp:export')")
    @Log(title = "设计-井控专篇", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjJkzp sjJkzp)
    {
        List<SjJkzp> list = sjJkzpService.selectSjJkzpList(sjJkzp);
        ExcelUtil<SjJkzp> util = new ExcelUtil<SjJkzp>(SjJkzp.class);
        util.exportExcel(response, list, "设计-井控专篇数据");
    }

    /**
     * 获取设计-井控专篇详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJkzp:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjJkzpService.selectSjJkzpById(id));
    }

    /**
     * 新增设计-井控专篇
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJkzp:add')")
    @Log(title = "设计-井控专篇", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjJkzp sjJkzp)
    {
        return toAjax(sjJkzpService.insertSjJkzp(sjJkzp));
    }

    /**
     * 修改设计-井控专篇
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJkzp:edit')")
    @Log(title = "设计-井控专篇", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjJkzp sjJkzp)
    {
        return toAjax(sjJkzpService.updateSjJkzp(sjJkzp));
    }

    /**
     * 删除设计-井控专篇
     */
    //@PreAuthorize("@ss.hasPermi('system:sjJkzp:remove')")
    @Log(title = "设计-井控专篇", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjJkzpService.deleteSjJkzpByIds(ids));
    }
}
