package com.zjsgfa.project.zjsgfa.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.zjsgfa.framework.aspectj.lang.annotation.Log;
import com.zjsgfa.framework.aspectj.lang.enums.BusinessType;
import com.zjsgfa.project.zjsgfa.domain.SjFl;
import com.zjsgfa.project.zjsgfa.service.ISjFlService;
import com.zjsgfa.framework.web.controller.BaseController;
import com.zjsgfa.framework.web.domain.AjaxResult;
import com.zjsgfa.common.utils.poi.ExcelUtil;
import com.zjsgfa.framework.web.page.TableDataInfo;

/**
 * 设计-附录Controller
 * 
 * @author
 * @date 2025-07-25
 */
@RestController
@RequestMapping("/system/sjFl")
public class SjFlController extends BaseController
{
    @Autowired
    private ISjFlService sjFlService;

    /**
     * 查询设计-附录列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFl:list')")
    @GetMapping("/list")
    public TableDataInfo list(SjFl sjFl)
    {
        startPage();
        List<SjFl> list = sjFlService.selectSjFlList(sjFl);
        return getDataTable(list);
    }

    @GetMapping("/getInfoByJh")
    public AjaxResult getInfoByJh(SjFl sjFl)
    {
//        startPage();
        List<SjFl> list = sjFlService.selectSjFlList(sjFl);
        SjFl sjFl1=new SjFl();
        if(list.size()>0){
            sjFl1=list.get(0);
        }
        return AjaxResult.success(sjFl1);
    }

    /**
     * 导出设计-附录列表
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFl:export')")
    @Log(title = "设计-附录", businessType = BusinessType.EXPORT)
    @PostMapping("/export")
    public void export(HttpServletResponse response, SjFl sjFl)
    {
        List<SjFl> list = sjFlService.selectSjFlList(sjFl);
        ExcelUtil<SjFl> util = new ExcelUtil<SjFl>(SjFl.class);
        util.exportExcel(response, list, "设计-附录数据");
    }

    /**
     * 获取设计-附录详细信息
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFl:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id)
    {
        return success(sjFlService.selectSjFlById(id));
    }

    /**
     * 新增设计-附录
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFl:add')")
    @Log(title = "设计-附录", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody SjFl sjFl)
    {
        return toAjax(sjFlService.insertSjFl(sjFl));
    }

    /**
     * 修改设计-附录
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFl:edit')")
    @Log(title = "设计-附录", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody SjFl sjFl)
    {
        return toAjax(sjFlService.updateSjFl(sjFl));
    }

    /**
     * 删除设计-附录
     */
    //@PreAuthorize("@ss.hasPermi('system:sjFl:remove')")
    @Log(title = "设计-附录", businessType = BusinessType.DELETE)
	@DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids)
    {
        return toAjax(sjFlService.deleteSjFlByIds(ids));
    }
}
