package com.qianhe.service.impl;

import java.util.List;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.domain.JygxLxwh;
import com.qianhe.mapper.JygxLxwhMapper;
import com.qianhe.service.IJygxLxwhService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 经验共享-类型维护Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-29
 */
@Service
public class JygxLxwhServiceImpl implements IJygxLxwhService
{
    @Autowired
    private JygxLxwhMapper jygxLxwhMapper;

    /**
     * 查询经验共享-类型维护
     *
     * @param lxid 经验共享-类型维护主键
     * @return 经验共享-类型维护
     */
    @Override
    public JygxLxwh selectJygxLxwhByLxid(Long lxid)
    {
        return jygxLxwhMapper.selectJygxLxwhByLxid(lxid);
    }

    /**
     * 查询经验共享-类型维护列表
     *
     * @param jygxLxwh 经验共享-类型维护
     * @return 经验共享-类型维护
     */
    @Override
    public List<JygxLxwh> selectJygxLxwhList(JygxLxwh jygxLxwh)
    {
        return jygxLxwhMapper.selectJygxLxwhList(jygxLxwh);
    }

    /**
     * 新增经验共享-类型维护
     *
     * @param jygxLxwh 经验共享-类型维护
     * @return 结果
     */
    @Override
    public int insertJygxLxwh(JygxLxwh jygxLxwh)
    {
        jygxLxwh.setCreateTime(DateUtils.getNowDate());
        return jygxLxwhMapper.insertJygxLxwh(jygxLxwh);
    }

    /**
     * 修改经验共享-类型维护
     *
     * @param jygxLxwh 经验共享-类型维护
     * @return 结果
     */
    @Override
    public int updateJygxLxwh(JygxLxwh jygxLxwh)
    {
        jygxLxwh.setUpdateTime(DateUtils.getNowDate());
        return jygxLxwhMapper.updateJygxLxwh(jygxLxwh);
    }

    /**
     * 批量删除经验共享-类型维护
     *
     * @param lxids 需要删除的经验共享-类型维护主键
     * @return 结果
     */
    @Override
    public int deleteJygxLxwhByLxids(Long[] lxids)
    {
        return jygxLxwhMapper.deleteJygxLxwhByLxids(lxids);
    }

    /**
     * 删除经验共享-类型维护信息
     *
     * @param lxid 经验共享-类型维护主键
     * @return 结果
     */
    @Override
    public int deleteJygxLxwhByLxid(Long lxid)
    {
        return jygxLxwhMapper.deleteJygxLxwhByLxid(lxid);
    }
}
