package com.qianhe.service.impl;

import java.util.List;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.domain.JygxCljwh;
import com.qianhe.mapper.JygxCljwhMapper;
import com.qianhe.service.IJygxCljwhService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;


/**
 * 经验共享-超链接维护Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-30
 */
@Service
public class JygxCljwhServiceImpl implements IJygxCljwhService
{
    @Autowired
    private JygxCljwhMapper jygxCljwhMapper;

    /**
     * 查询经验共享-超链接维护
     *
     * @param cljid 经验共享-超链接维护主键
     * @return 经验共享-超链接维护
     */
    @Override
    public JygxCljwh selectJygxCljwhByCljid(Long cljid)
    {
        return jygxCljwhMapper.selectJygxCljwhByCljid(cljid);
    }

    /**
     * 查询经验共享-超链接维护列表
     *
     * @param jygxCljwh 经验共享-超链接维护
     * @return 经验共享-超链接维护
     */
    @Override
    public List<JygxCljwh> selectJygxCljwhList(JygxCljwh jygxCljwh)
    {
        return jygxCljwhMapper.selectJygxCljwhList(jygxCljwh);
    }

    /**
     * 新增经验共享-超链接维护
     *
     * @param jygxCljwh 经验共享-超链接维护
     * @return 结果
     */
    @Override
    public int insertJygxCljwh(JygxCljwh jygxCljwh)
    {
        jygxCljwh.setCreateTime(DateUtils.getNowDate());
        return jygxCljwhMapper.insertJygxCljwh(jygxCljwh);
    }

    /**
     * 修改经验共享-超链接维护
     *
     * @param jygxCljwh 经验共享-超链接维护
     * @return 结果
     */
    @Override
    public int updateJygxCljwh(JygxCljwh jygxCljwh)
    {
        jygxCljwh.setUpdateTime(DateUtils.getNowDate());
        return jygxCljwhMapper.updateJygxCljwh(jygxCljwh);
    }

    /**
     * 批量删除经验共享-超链接维护
     *
     * @param cljids 需要删除的经验共享-超链接维护主键
     * @return 结果
     */
    @Override
    public int deleteJygxCljwhByCljids(Long[] cljids)
    {
        return jygxCljwhMapper.deleteJygxCljwhByCljids(cljids);
    }

    /**
     * 删除经验共享-超链接维护信息
     *
     * @param cljid 经验共享-超链接维护主键
     * @return 结果
     */
    @Override
    public int deleteJygxCljwhByCljid(Long cljid)
    {
        return jygxCljwhMapper.deleteJygxCljwhByCljid(cljid);
    }
}
