package com.qianhe.system.service.impl;

import java.util.List;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.system.domain.SysDeptFl;
import com.qianhe.system.mapper.SysDeptFlMapper;
import com.qianhe.system.service.ISysDeptFlService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 单位分类Service业务层处理
 *
 * @author qianhe
 * @date 2024-07-22
 */
@Service
public class SysDeptFlServiceImpl implements ISysDeptFlService
{
    @Autowired
    private SysDeptFlMapper sysDeptFlMapper;

    /**
     * 查询单位分类
     *
     * @param id 单位分类主键
     * @return 单位分类
     */
    @Override
    public SysDeptFl selectSysDeptFlById(Long id)
    {
        return sysDeptFlMapper.selectSysDeptFlById(id);
    }

    /**
     * 查询单位分类列表
     *
     * @param sysDeptFl 单位分类
     * @return 单位分类
     */
    @Override
    public List<SysDeptFl> selectSysDeptFlList(SysDeptFl sysDeptFl)
    {
        return sysDeptFlMapper.selectSysDeptFlList(sysDeptFl);
    }

    /**
     * 新增单位分类
     *
     * @param sysDeptFl 单位分类
     * @return 结果
     */
    @Override
    public int insertSysDeptFl(SysDeptFl sysDeptFl)
    {
        sysDeptFl.setCreateTime(DateUtils.getNowDate());
        return sysDeptFlMapper.insertSysDeptFl(sysDeptFl);
    }

    /**
     * 修改单位分类
     *
     * @param sysDeptFl 单位分类
     * @return 结果
     */
    @Override
    public int updateSysDeptFl(SysDeptFl sysDeptFl)
    {
        sysDeptFl.setUpdateTime(DateUtils.getNowDate());
        return sysDeptFlMapper.updateSysDeptFl(sysDeptFl);
    }

    /**
     * 批量删除单位分类
     *
     * @param ids 需要删除的单位分类主键
     * @return 结果
     */
    @Override
    public int deleteSysDeptFlByIds(Long[] ids)
    {
        return sysDeptFlMapper.deleteSysDeptFlByIds(ids);
    }

    /**
     * 删除单位分类信息
     *
     * @param id 单位分类主键
     * @return 结果
     */
    @Override
    public int deleteSysDeptFlById(Long id)
    {
        return sysDeptFlMapper.deleteSysDeptFlById(id);
    }
}
