package com.qianhe.service.impl;

import com.qianhe.common.annotation.DataScope;
import com.qianhe.common.utils.DateUtils;
import com.qianhe.common.utils.SecurityUtils;
import com.qianhe.common.utils.StringUtils;
import com.qianhe.domain.SjGfjsYdjcjl;
import com.qianhe.domain.SjGfjsZsdwwtcj;
import com.qianhe.mapper.SjGfjsYdjcjlMapper;
import com.qianhe.service.ISjGfjsYdjcjlService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;

/**
 * 规范建设 月度检查记录Service业务层处理
 */
@Service
public class SjGfjsYdjcjlServiceImpl implements ISjGfjsYdjcjlService
{
    @Autowired
    private SjGfjsYdjcjlMapper sjGfjsYdjcjlMapper;

    /**
     * 查询规范建设 月度检查记录
     *
     * @param id 规范建设 月度检查记录主键
     * @return 规范建设 月度检查记录
     */
    @Override
    public SjGfjsYdjcjl selectSjGfjsYdjcjlById(Long id)
    {
        SjGfjsYdjcjl zsdwwtcj = sjGfjsYdjcjlMapper.selectSjGfjsYdjcjlById(id);
        return zsdwwtcj;
    }

    /**
     * 查询规范建设 月度检查记录列表
     *
     * @param sjGfjsYdjcjl 规范建设 月度检查记录
     * @return 规范建设 月度检查记录
     */
    @Override
    @DataScope(deptAlias = "d")
    public List<SjGfjsYdjcjl> selectSjGfjsYdjcjlList(SjGfjsYdjcjl sjGfjsYdjcjl)
    {
        return sjGfjsYdjcjlMapper.selectSjGfjsYdjcjlList(sjGfjsYdjcjl);
    }

    @Override
    public List<SjGfjsYdjcjl> selectSjGfjsYdjcjlList_main(SjGfjsYdjcjl sjGfjsYdjcjl)
    {
        return sjGfjsYdjcjlMapper.selectSjGfjsYdjcjlList_main(sjGfjsYdjcjl);
    }

    /**
     * 新增规范建设 月度检查记录
     *
     * @param sjGfjsYdjcjl 规范建设 月度检查记录
     * @return 结果
     */
    @Override
    @Transactional
    public int insertSjGfjsYdjcjl(SjGfjsYdjcjl sjGfjsYdjcjl)
    {
        sjGfjsYdjcjl.setCreateTime(DateUtils.getNowDate());
        sjGfjsYdjcjl.setCreateBy(SecurityUtils.getUsername());

        //判断是否有问题
        List<SjGfjsZsdwwtcj> sjGfjsZsdwwtcjList = sjGfjsYdjcjl.getSjGfjsZsdwwtcjList();
        if(sjGfjsZsdwwtcjList != null && sjGfjsZsdwwtcjList.size() > 0){
            sjGfjsYdjcjl.setSfczwt("Y");
        } else {
            sjGfjsYdjcjl.setSfczwt("N");
        }

        int rows = sjGfjsYdjcjlMapper.insertSjGfjsYdjcjl(sjGfjsYdjcjl);
        insertSjGfjsZsdwwtcj(sjGfjsYdjcjl);
        return rows;
    }

    /**
     * 修改规范建设 月度检查记录
     *
     * @param sjGfjsYdjcjl 规范建设 月度检查记录
     * @return 结果
     */
    @Override
    @Transactional
    public int updateSjGfjsYdjcjl(SjGfjsYdjcjl sjGfjsYdjcjl)
    {
        sjGfjsYdjcjl.setUpdateTime(DateUtils.getNowDate());
        sjGfjsYdjcjl.setUpdateBy(SecurityUtils.getUsername());

        sjGfjsYdjcjlMapper.deleteSjGfjsZsdwwtcjByPid(sjGfjsYdjcjl.getId());
        insertSjGfjsZsdwwtcj(sjGfjsYdjcjl);

        //判断是否有问题
        List<SjGfjsZsdwwtcj> sjGfjsZsdwwtcjList = sjGfjsYdjcjl.getSjGfjsZsdwwtcjList();
        if(sjGfjsZsdwwtcjList != null && sjGfjsZsdwwtcjList.size() > 0){
            sjGfjsYdjcjl.setSfczwt("Y");
        } else {
            sjGfjsYdjcjl.setSfczwt("N");
        }

        return sjGfjsYdjcjlMapper.updateSjGfjsYdjcjl(sjGfjsYdjcjl);
    }
    //月度检查记录提交
    @Override
    @Transactional
    public int tjSjGfjsYdjcjl(SjGfjsYdjcjl ydjl)
    {
        SjGfjsYdjcjl upd = new SjGfjsYdjcjl();
        upd.setId(ydjl.getId());
        upd.setUpdateTime(DateUtils.getNowDate());
        upd.setUpdateBy(SecurityUtils.getUsername());
        upd.setZt("1");//已提交
        return sjGfjsYdjcjlMapper.updateSjGfjsYdjcjl(upd);
    }
    //月度检查记录提交
    @Override
    @Transactional
    public int sh(SjGfjsYdjcjl ydjl)
    {
        SjGfjsYdjcjl upd = new SjGfjsYdjcjl();
        upd.setId(ydjl.getId());
        upd.setUpdateTime(DateUtils.getNowDate());
        upd.setUpdateBy(SecurityUtils.getUsername());
        upd.setZt(ydjl.getZt());//已提交
        return sjGfjsYdjcjlMapper.updateSjGfjsYdjcjl(upd);
    }

    /**
     * 批量删除规范建设 月度检查记录
     *
     * @param ids 需要删除的规范建设 月度检查记录主键
     * @return 结果
     */
    @Override
    public int deleteSjGfjsYdjcjlByIds(Long[] ids)
    {
        sjGfjsYdjcjlMapper.deleteSjGfjsZsdwwtcjByPids(ids);
        return sjGfjsYdjcjlMapper.deleteSjGfjsYdjcjlByIds(ids);
    }

    /**
     * 删除规范建设 月度检查记录信息
     *
     * @param id 规范建设 月度检查记录主键
     * @return 结果
     */
    @Override
    public int deleteSjGfjsYdjcjlById(Long id)
    {
        sjGfjsYdjcjlMapper.deleteSjGfjsZsdwwtcjByPid(id);
        return sjGfjsYdjcjlMapper.deleteSjGfjsYdjcjlById(id);
    }

    /**
     * 新增规范建设 月度检查记录 问题从信息
     *
     * @param sjGfjsYdjcjl 规范建设 月度检查记录对象
     */
    public void insertSjGfjsZsdwwtcj(SjGfjsYdjcjl sjGfjsYdjcjl)
    {
        List<SjGfjsZsdwwtcj> sjGfjsZsdwwtcjList = sjGfjsYdjcjl.getSjGfjsZsdwwtcjList();
        Long id = sjGfjsYdjcjl.getId();
        if (StringUtils.isNotNull(sjGfjsZsdwwtcjList))
        {
            List<SjGfjsZsdwwtcj> list = new ArrayList<SjGfjsZsdwwtcj>();
            for (SjGfjsZsdwwtcj sjGfjsZsdwwtcj : sjGfjsZsdwwtcjList)
            {
                sjGfjsZsdwwtcj.setPid(id);

                sjGfjsZsdwwtcj.setDeptId(sjGfjsYdjcjl.getDeptId());
                sjGfjsZsdwwtcj.setRq(sjGfjsYdjcjl.getRq());
                sjGfjsZsdwwtcj.setJcjb(sjGfjsYdjcjl.getJcjb());

                sjGfjsZsdwwtcj.setCreateTime(DateUtils.getNowDate());
                sjGfjsZsdwwtcj.setCreateBy(SecurityUtils.getUsername());
                list.add(sjGfjsZsdwwtcj);
            }
            if (list.size() > 0)
            {
                sjGfjsYdjcjlMapper.batchSjGfjsZsdwwtcj(list);
            }
        }
    }
}
