package com.qianhe.domain;

import com.qianhe.common.annotation.Excel;
import com.qianhe.common.core.domain.BaseEntity;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 指导帮扶-直属单位考核评价主对象 sj_zdbf_zsdwkhpj_zb
 *
 * @author qianhe
 * @date 2024-07-24
 */
@Data
public class SjGfjsZsdwkhpjZb extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 主键 */
    private Long id;

    /** 单位id */
//    @Excel(name = "单位id")
    private Long deptId;
    @Excel(name = "直属单位名称")
    private String parentName;
    @Excel(name = "基层单位名称")
    private String deptName;

    /** 上级单位id */
//    @Excel(name = "上级单位id")
    private Long parentDeptId;

    /** 年度 */
    @Excel(name = "年度")
    private String nd;

    /** 周期范围（第一季度-第四季度、上半年、下半年） */
//    @Excel(name = "周期范围")
    private String zqfw;

    /** 周期类型（季度、半年度、年度） */
//    @Excel(name = "周期类型")
    private String zqlx;

    /** 级别（直属单位（半年度）、基层单位（季度）、三基帮扶组（年度）） */
//    @Excel(name = "级别", readConverterExp = "直=属单位（半年度")
    private String jb;

    /** 单位大分类（A类基层单位、B类基层单位、C类基层单位） */
    @Excel(name = "单位分类")
    private String deptDfl;

    /** 单位类型（采油管理区、专业化基础单位、科研基层单位、服务协调基础单位） */
    @Excel(name = "单位类型")
    private String deptLx;

    /** 单位业务分类 */
    @Excel(name = "单位业务分类")
    private String deptYwfl;

    /** 党建引领总分数 */
    @Excel(name = "党建引领总分数")
    private BigDecimal djyjzfs;

    /** 党建引领扣分数 */
    @Excel(name = "党建引领扣分数")
    private BigDecimal djyjkfs;

    /** 党建引领扣分比例 */
    @Excel(name = "党建引领扣分比例")
    private BigDecimal djyjkfbl;

    /** 党建引领得分 */
    @Excel(name = "党建引领得分")
    private BigDecimal djyjdf;

    /** 素质提升总分数 */
    @Excel(name = "素质提升总分数")
    private BigDecimal sztszfs;

    /** 素质提升扣分数 */
    @Excel(name = "素质提升扣分数")
    private BigDecimal sztskfs;

    /** 素质提升扣分比例 */
    @Excel(name = "素质提升扣分比例")
    private BigDecimal sztsfbl;

    /** 素质提升得分 */
    @Excel(name = "素质提升得分")
    private BigDecimal sztsdf;

    /** 管理规范总分数 */
    @Excel(name = "管理规范总分数")
    private BigDecimal glgfzfs;

    /** 管理规范扣分数 */
    @Excel(name = "管理规范扣分数")
    private BigDecimal glgfkfs;

    /** 管理规范扣分比例 */
    @Excel(name = "管理规范扣分比例")
    private BigDecimal glgfbl;

    /** 管理规范得分 */
    @Excel(name = "管理规范得分")
    private BigDecimal glgfdf;

    /** 管理规范总分数 */
    @Excel(name = "管理规范总分数")
    private BigDecimal ywcxzfs;

    /** 管理规范扣分数 */
    @Excel(name = "管理规范扣分数")
    private BigDecimal ywcxkfs;

    /** 管理规范扣分比例 */
    @Excel(name = "管理规范扣分比例")
    private BigDecimal ywcxbl;

    /** 管理规范得分 */
    @Excel(name = "管理规范得分")
    private BigDecimal ywcxdf;

    /** 发生否决项数量 */
    @Excel(name = "发生否决项数量")
    private BigDecimal sffjxs;

    /** 总扣分 */
    @Excel(name = "总扣分")
    private BigDecimal zkf;

    /** 总扣分比例 */
    @Excel(name = "总扣分比例")
    private BigDecimal zkfbl;

    /** 总得分 */
    @Excel(name = "总得分")
    private BigDecimal zdf;

    /** 综合得分 */
    @Excel(name = "综合得分")
    private BigDecimal zhdf;

    /** 预留1 */
//    @Excel(name = "预留1")
    private String yl1;

    /** 预留2 */
//    @Excel(name = "预留2")
    private String yl2;

    /** 预留3 */
//    @Excel(name = "预留3")
    private String yl3;

    /** 预留4 */
//    @Excel(name = "预留4")
    private String yl4;

    /** 预留5 */
//    @Excel(name = "预留5")
    private String yl5;

    /**
     * 得分查询条件
     */

    private BigDecimal df;

    /**
     * 扣分比例查询条件
     */
    private BigDecimal kfbl;

    /**
     * 否决项
     */
    private BigDecimal fjx;

    /**
     * 排名
     */
    private int pm;
    /**
     * 状态 0 未提交 1 已提交
     */
    private String zt;

    /**
     * ABCD
     */
    private String fdjb;

}
